package gdxapp.screens.ObjectEditor;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.GL20;

import dressing.ui.parts.GdxPart;
import gdxapp.object3d.WorldObject;

public class ObjectEditorScreen implements Screen {

	private ObjectEditorController controller;
	
	private static ObjectEditorScreen screen;
	
	private  ObjectEditorScreen() {
		super();
		this.controller = new ObjectEditorController();
	}


	@Override
	public void show() {
		this.controller.inputHandler.processInput();
	}

	@Override
	public void render(float delta) {
    	Gdx.gl.glClearColor(0.25f, 0.25f, 0.25f, 1);
        Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT | (Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
        controller.render();
	}

	@Override
	public void resize(int width, int height) {
		
	}

	@Override
	public void hide() {
		controller.addObjectsToScene();
	}

	@Override
	public void dispose() {
		
	}

	@Override
	public void pause() {}

	@Override
	public void resume() {}

	public void setObject(WorldObject object) {
		controller.setObject(object);
	}

	public static ObjectEditorScreen getScreen() {
		if(screen == null)
			screen = new ObjectEditorScreen();
		return screen;
	}


	
	
}
