package gdxapp.screens.ObjectEditor;

import java.util.HashMap;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton.ImageButtonStyle;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;

import gdxapp.assets.AssetsTextures;

public class EditorSkin extends Skin {
	
	static public final String MOVE_STYLE = "move";
    static public final String SELECT_STYLE = "select";
    static public final String SCALE_STYLE = "scale";
    static public final String ROTATE_STYLE = "rotate";
    static public final String CUBE_STYLE = "gen_cube";
    static public final String CYLINDER_STYLE = "gen_cyl";
    static public final String SPHERE_STYLE = "gen_sphere";
    
    static public final String TOP_VUE_STYLE = "top_vue";
    static public final String BOTTOM_VUE_STYLE = "bottom_vue";
    static public final String LEFT_VUE_STYLE = "left_vue";
    static public final String RIGHT_VUE_STYLE = "right_vue";
    static public final String FRONT_VUE_STYLE = "front_vue";
    static public final String BACK_VUE_STYLE = "back_vue";
    
    static public final String RIGHT_ARROW_STYLE = "right_arrow";
    static public final String LEFT_ARROW_STYLE = "left_arrow";
    static public final String UP_ARROW_STYLE = "up_arrow";
    static public final String DOWN_ARROW_STYLE = "down_arrow";
    
    static public final String PIPE_STYLE = "pipe";

    private static EditorSkin skin;

    private EditorSkin(){}

    private final HashMap<String, ImageButton.ImageButtonStyle> imageBtnStyles = new HashMap<>();

    public  void prepare(){
    	
        Texture selectIcon = AssetsTextures.getInstance().getIcon("select-64.png");
        ImageButtonStyle selectStyle = new ImageButton.ImageButtonStyle();
        selectStyle.imageUp = new TextureRegionDrawable(new TextureRegion(selectIcon));
        imageBtnStyles.put(SELECT_STYLE, selectStyle);

        Texture moveIcon = AssetsTextures.getInstance().getIcon("move-64.png");
        ImageButton.ImageButtonStyle moveStyle = new ImageButton.ImageButtonStyle();
        moveStyle.imageUp = new TextureRegionDrawable(new TextureRegion(moveIcon));
        imageBtnStyles.put(MOVE_STYLE, moveStyle);


        Texture scaleIcon = AssetsTextures.getInstance().getIcon("resize-64.png");
        ImageButton.ImageButtonStyle scaleStyle = new ImageButton.ImageButtonStyle();
        scaleStyle.imageUp = new TextureRegionDrawable(new TextureRegion(scaleIcon));
        imageBtnStyles.put(SCALE_STYLE, scaleStyle);


        Texture rotateIcon = AssetsTextures.getInstance().getIcon("rotate-64.png");
        ImageButton.ImageButtonStyle rotateStyle = new ImageButton.ImageButtonStyle();
        rotateStyle.imageUp = new TextureRegionDrawable(new TextureRegion(rotateIcon));
        imageBtnStyles.put(ROTATE_STYLE, rotateStyle);

        Texture cubeIcon = AssetsTextures.getInstance().getIcon("cube-64.png");
        ImageButton.ImageButtonStyle cubeStyle = new ImageButton.ImageButtonStyle();
        cubeStyle.imageUp = new TextureRegionDrawable(new TextureRegion(cubeIcon));
        imageBtnStyles.put(CUBE_STYLE, cubeStyle);

        Texture cylinderIcon = AssetsTextures.getInstance().getIcon("cylinder-64.png");
        ImageButton.ImageButtonStyle cylinderStyle = new ImageButton.ImageButtonStyle();
        cylinderStyle.imageUp = new TextureRegionDrawable(new TextureRegion(cylinderIcon));
        imageBtnStyles.put(CYLINDER_STYLE, cylinderStyle);

        Texture sphereIcon = AssetsTextures.getInstance().getIcon("round-64.png");
        ImageButton.ImageButtonStyle sphereStyle = new ImageButton.ImageButtonStyle();
        sphereStyle.imageUp = new TextureRegionDrawable(new TextureRegion(sphereIcon));
        imageBtnStyles.put(SPHERE_STYLE, sphereStyle);
        
        Texture frontTexture = AssetsTextures.getInstance().getIcon("front.png");
        ImageButton.ImageButtonStyle frontStyle = new ImageButton.ImageButtonStyle();
        frontStyle.imageUp = new TextureRegionDrawable(new TextureRegion(frontTexture));
        imageBtnStyles.put(FRONT_VUE_STYLE, frontStyle);
        Texture backText = AssetsTextures.getInstance().getIcon("back.png");
        ImageButton.ImageButtonStyle backStyle = new ImageButton.ImageButtonStyle();
        backStyle.imageUp = new TextureRegionDrawable(new TextureRegion(backText));
        imageBtnStyles.put(BACK_VUE_STYLE, backStyle);
        Texture topIcon = AssetsTextures.getInstance().getIcon("top.png");
        ImageButton.ImageButtonStyle topStyle = new ImageButton.ImageButtonStyle();
        topStyle.imageUp = new TextureRegionDrawable(new TextureRegion(topIcon));
        imageBtnStyles.put(TOP_VUE_STYLE, topStyle);
        Texture bottomIcon = AssetsTextures.getInstance().getIcon("bottom.png");
        imageBtnStyles.put(BOTTOM_VUE_STYLE, createImgBtnStyle(bottomIcon));
        Texture leftIcon = AssetsTextures.getInstance().getIcon("left.png");
        imageBtnStyles.put(LEFT_VUE_STYLE, createImgBtnStyle(leftIcon));        
        Texture rightIcon = AssetsTextures.getInstance().getIcon("right.png");
        imageBtnStyles.put(RIGHT_VUE_STYLE, createImgBtnStyle(rightIcon));
        
        Texture icon = AssetsTextures.getInstance().getIcon("right-arrow.png");
        imageBtnStyles.put(RIGHT_ARROW_STYLE, createImgBtnStyle(icon));
        Texture icon1 = AssetsTextures.getInstance().getIcon("left-arrow.png");
        imageBtnStyles.put(LEFT_ARROW_STYLE, createImgBtnStyle(icon1));
        Texture icon2 = AssetsTextures.getInstance().getIcon("up-arrow.png");
        imageBtnStyles.put(UP_ARROW_STYLE, createImgBtnStyle(icon2));
        Texture icon3 = AssetsTextures.getInstance().getIcon("down-arrow.png");
        imageBtnStyles.put(DOWN_ARROW_STYLE, createImgBtnStyle(icon3));
        
        Texture pipeIcon = AssetsTextures.getInstance().getIcon("water-pipe-48.png");
        imageBtnStyles.put(PIPE_STYLE, createImgBtnStyle(pipeIcon));
        
    }

    public static EditorSkin getSkin() {
        if(skin == null){
            skin = new EditorSkin();
            skin.prepare();
        }

        return skin;
    }
    
    public static ImageButtonStyle createImgBtnStyle(Texture texture) {
        ImageButtonStyle style = new ImageButton.ImageButtonStyle();
        style.imageUp = new TextureRegionDrawable(new TextureRegion(texture));
        return style;
    }
    
    public ImageButton.ImageButtonStyle getImageVtnStyle(String key){
        return this.imageBtnStyles.get(key);
    }


}
