package gdxapp.quotation;

import java.util.ArrayList;


import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;

public class QuotationSorter {
	
	 	private ArrayList<Quotation> quotations;

	    private static QuotationSorter instance = new QuotationSorter();
	    
	    private ArrayList<Vector2> groups;

	    private QuotationSorter(){ }

	    public void addQuotation(Quotation quotation){
	        if(quotations == null)
	            quotations = new ArrayList<Quotation>();
	        quotations.add(quotation);
	    }

	    public void removeQuotation(Quotation quotation){
	        if(quotations != null)
	            quotations.remove(quotation);
	    }

	    public void sortQuotations(){
	    	removeRedundauntQuotation();
	    	ArrayList<Quotation[]> groupedQuotations = groupByDirection();
	    	for(Quotation[] group: groupedQuotations) {
	    		sortQuotations(group);
	    	}
	    }
	    public void sortQuotations(Quotation[] quotations){
	        boolean indicesChanged = false;
	        do{
	            indicesChanged = false;
	            Quotation bucket;
	            for(int i = 0; i < quotations.length - 1; i++){
	                if(quotations[i].getLength() > quotations[i+1].getLength()){
	                    bucket =  quotations[i];
	                    quotations[i] = quotations[i+1];
	                    quotations[i+1] = bucket;
	                    indicesChanged = true;
	                }
	            }
	        }while (indicesChanged);
	        float distance = 25;
	        for(int i = 0; i < quotations.length; i ++){
	        	quotations[i].setDistance(distance);
	            distance += 25;
	        }
	    }

	    public ArrayList<Quotation[]> groupByDirection(){

	    	ArrayList<Quotation[]> groupedQuotations = new ArrayList<Quotation[]>();
	        groups = new ArrayList<Vector2>();
	        for(Quotation quotation : quotations){
	        	Vector2 director = quotation.getEdge().getDirector();
	        	if(groups.isEmpty()) {
	        		groups.add(director);
	        		continue;
	        	}
	        	boolean exist = false;
	            for(Vector2 direction: groups){
	                if(direction.isCollinear(director,.01f)) {
	                	exist = true;
	                	break;
	                }
	            }
	            if(!exist) {
	            	groups.add(director);
	            }
	        }
	        for(Vector2 vect : groups) {
            	ArrayList<Quotation> groupQuotationList = new ArrayList<Quotation>();
            	for(Quotation quotat: this.quotations) {
            		if(quotat.getEdge().getDirector().isCollinear(vect, .01f)) {
            			groupQuotationList.add(quotat);
            		}
            	}
            	Quotation[] groupQuotationArray = new Quotation[groupQuotationList.size()];
            	groupQuotationList.toArray(groupQuotationArray);
            	groupedQuotations.add(groupQuotationArray);
            }
	        return groupedQuotations;
	    }
	    
	    public void removeRedundauntQuotation() {
	    	ArrayList<Quotation> nonRedundantList = new ArrayList<Quotation>();
	    	for(Quotation quotation: quotations) {
	    		boolean duplicate = false;
	    		for(Quotation qoutationX: nonRedundantList) {
	    			if(quotation.equivalentTo(qoutationX)) {
	    				duplicate = true;
	    				break;
	    			}
	    		}
	    		if(!duplicate)
	    			nonRedundantList.add(quotation);
	    	}
	    	quotations.clear();
	    	for(Quotation quot: nonRedundantList) {
	    		quotations.add(quot);
	    	}
	    }

	    public void draw(Batch batch){
	    	if(quotations != null) {
	    		 for(Quotation quot: this.quotations){
	 	            quot.draw(batch, Color.BLUE,true, 2);
	 	        }
	    	}
	    }


	    public static QuotationSorter getInstance() {
	        return instance;
	    }

	    public void setInstance(QuotationSorter instance) {
	        this.instance = instance;
	    }

	    public ArrayList<Quotation> getQuotations() {
	        return quotations;
	    }

	    public void setQuotations(ArrayList<Quotation> quotations) {
	        this.quotations = quotations;
	        sortQuotations();
	    }

}
