package gdxapp.object3d;


import dressing.model.persistence.dpos.GeometryDPO;
import dressing.model.persistence.dpos.Object3D;
import dressing.model.persistence.mappers.Persistable;
import geometry.CompoundObject;

@Persistable(persistableForm = GeometryDPO.class)
public class GeometryObject extends WorldObject {
	
	protected CompoundObject geometry;
	
	public GeometryObject() {
		super();
		type = ObjectType.POLY;
	}
	
	public GeometryObject(CompoundObject geometry) {
		this();
		this.geometry = geometry;
	}
	
	

	public CompoundObject getGeometry() {
		return geometry;
	}

	public void setGeometry(CompoundObject geometry) {
		this.geometry = geometry;
	}
	
	
	@Override
	public <T extends Object3D> T toDPO() {
		return (T) new GeometryDPO();
	}

	@Override
	public <T extends Object2D> T create2DObject() {
		return (T) new GeometryObject2D(this);
	}

	@Override
	public WorldObject clone() {
		GeometryObject clone = new GeometryObject();
		clone.setRealWorldDimension(getRealWorldDimension());
		clone.setRealWorldPosition(getRealWorldPosition());
		clone.setModel(this.getModel());
		clone.setGeometry(this.geometry.cpy());
		clone.setUuid(getUuid());
		clone.setSceneId(getSceneId());
		clone.setUserData(getUserData());
		return clone;
	}

	@Override
	public GeometryObject copy() {
		GeometryObject copy = new GeometryObject();
		copy.setGeometry(getGeometry().cpy());
		return copy;
	}
	
}
