package gdxapp.object3d;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;

import dressing.events.Event;
import dressing.events.EventHandler;
import gdxapp.scenes.SceneEvent;

public class FullScreenActor extends Actor implements EventHandler {
	
	protected OrthographicCamera camera;
	
	public FullScreenActor() {
		subscribe(SceneEvent.STAGE_CAMERA_CHANGED.name());
	}

	
	protected void onCameraChanged() {
		Vector3 upperBound =  getCamera().unproject(new Vector3(camera.viewportWidth, 0, 0));
		Vector3 lowerBound =  camera.unproject(new Vector3(0, camera.viewportHeight, 0));
		Vector3 size = upperBound.cpy().sub(lowerBound);
		Vector3 center = upperBound.add(lowerBound).scl(0.5f);
		setPosition(center.x - size.x/2.0f, center.y - size.y/2.0f); // move to the left bottom corner
		setSize(size.x, size.y);
	}


	@Override
	public void handle(Event event) {
		if(getStage() == null)
			return;
		SceneEvent eventType = SceneEvent.valueOf(event.getTopic());
		if(eventType ==  SceneEvent.STAGE_CAMERA_CHANGED) {
			if( event.getData() == getCamera()) {
				onCameraChanged();
			}
		}
	}
	
	public float getPixelWidth() {
		return getCamera().unproject(new Vector3(1,0,0)).sub(getCamera().unproject(new Vector3())).len();
	}


	public OrthographicCamera getCamera() {
		if(camera == null) {
			Stage stage = getStage();
			if(stage != null)
				setCamera((OrthographicCamera) stage.getCamera());
		}
		return camera;
	}


	public void setCamera(OrthographicCamera camera) {
		this.camera = camera;
		onCameraChanged();
	}
	
}
