package gdxapp.animation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

import gdxapp.object3d.Animation;

public class AnimationManager {
	
	private Stack<List<Animation>> animations = new Stack<List<Animation>>();
	private Stack<ICallable> postAnimationActions = new Stack<ICallable>();
	private List<Animation> currentAnimation;
	private List<Animation> nextAct = new ArrayList<Animation>();		
	private boolean playing = false;
	
	private static AnimationManager instance;
	
	private AnimationManager() {}
	
	public void animate(float delta) {
		if(!(playing || animations.isEmpty())) {
			currentAnimation = animations.pop();
			postAnimationActions.clear();
		}
		if(!(currentAnimation == null || currentAnimation.isEmpty())) {
			nextAct.clear();
			currentAnimation.forEach(a -> {
				Animation result = a.act(delta);
				if(result != null) {
					nextAct.add(result);
				}else {
					var postAnimation = a.getPostAnimationCallable();
					if(! (a.getPostAnimationCallable() == null || postAnimationActions.contains(postAnimation)))
						postAnimationActions.add(postAnimation);
				}
			});
			currentAnimation = nextAct.stream().filter( a -> a != null).toList();
			playing = !currentAnimation.isEmpty();
		}else {
			if(!postAnimationActions.isEmpty()) {
				long time = System.currentTimeMillis();
				do {
				}while(System.currentTimeMillis() < time + 1000);
				postAnimationActions.pop().call();
			}
		}
	}
	
	public void submitAnimations(Animation... animationArray) {
		animations.add(Arrays.asList(animationArray).stream().filter(a -> a != null).toList());
	}
	
	
	public static AnimationManager getInstance() {
		if(instance == null)
			instance = new AnimationManager();
		return instance;
	}
	
	
	
	

}
