package gdxapp;

import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import dressing.model.ProjectManager;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.ModelsLoader;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomScreen;
import gdxapp.ui.CursorProvider;
import supercad.provider.FacadeHandleProvider;

public class DressingRoomApp extends Game {

	public static final String TAG = DressingRoomApp.class.getName();
    private IEventBroker eventBroker;
	private ESelectionService selectionService;

	
	
	public DressingRoomApp(IEventBroker eventBroker) {
		this.eventBroker = eventBroker;
	}

	public void setSelectionService(ESelectionService selectionService) {
		this.selectionService = selectionService;
		ProjectManager.instance.getCurrentKitchen().getScene().setSelectionService(this.selectionService);
	}

	@Override
	public void create() {
		// ProgressBarMonitor.addtask();
		try {
			Scene.game = this;
			AssetsTextures.getInstance().init();
			ModelsLoader.getInstance().loadModels();
			Gdx.app.postRunnable(() -> FacadeHandleProvider.getInstance().loadHandles());
			CursorProvider.getInstance().init();
			setScreen(RoomScreen.getInstance());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void dispose() {
	}

	@Override
	public void setScreen(Screen screen) {
		if (screen.equals(getScreen())) {
			return;
		}
		super.setScreen(screen);
		Display.getDefault().asyncExec(() -> eventBroker.send(UIEvents.REQUEST_ENABLEMENT_UPDATE_TOPIC, null));
		System.gc();
	}

	@Override
	public void render() {
		try {
			if (screen != null)
				screen.render(Gdx.graphics.getDeltaTime());

		} catch (Exception e) {
			e.printStackTrace();
			System.err.println("gdx crushed");
		}
	}

	@Override
	public void resize(int width, int height) {
		super.resize(width, height);
	}

	
}
