package gdxapp.Commun;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import com.badlogic.gdx.graphics.g2d.Batch;
import dressing.mathutils.Surface;
import gdxapp.shapes.LineSegment;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Measure")
public class Measure implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private LineSegment lineSegment;
	private String description;
	private Surface context;
	private float size=0.0f;
	private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	/**
	 * Initializes new dimension line transient fields and reads its properties from
	 * <code>in</code> stream with default reading method.
	 */
	public void readObject(){
		this.propertyChangeSupport = new PropertyChangeSupport(this);
	}
	public Measure() {
		super();
		lineSegment = new LineSegment();
	}
	/**
	 * Adds the property change <code>listener</code> in parameter to this dimension
	 * line.
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		this.propertyChangeSupport.addPropertyChangeListener(listener);
	}

	/**
	 * Removes the property change <code>listener</code> in parameter from this
	 * dimension line.
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(listener);
	}
	public PropertyChangeSupport getPropertyChangeSupport() {
		if(propertyChangeSupport==null) {
			this.propertyChangeSupport = new PropertyChangeSupport(this);
		}
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	public void addPropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		getPropertyChangeSupport().addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(propertyName,listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,	Object newValue) {
			getPropertyChangeSupport().firePropertyChange(propertyName, oldValue,
					newValue);
					
	}
	public PropertyChangeListener[] getListeners() {
		
		return	getPropertyChangeSupport().getPropertyChangeListeners();
	}
	public void removeAllLsteners() {
		PropertyChangeListener[] listeners=getListeners();
		if(listeners==null) {
			return;
		}
		for(PropertyChangeListener listener:listeners) {
			getPropertyChangeSupport().removePropertyChangeListener(listener);
		}
	}
	
	public LineSegment getLineSegment() {
		return lineSegment;
	}


	public void setLineSegment(LineSegment lineSegment) {
		LineSegment oldValue =this.lineSegment;
		this.lineSegment = lineSegment;
		firePropertyChange("lineSegment", oldValue, this.lineSegment);
	}


	public String getDescription() {
		return description;
	}


	public void setDescription(String description) {
		String oldValue =this.description;
		this.description = description;
		firePropertyChange("description", oldValue, this.description);
	}

	public void draw(Batch batch, float parentAlpha) {
		if(lineSegment != null) {
			//lineSegment.draw(batch, parentAlpha);
		}
	}



	public Surface getContext() {
		return context;
	}

	public void setContext(Surface context) {
		Surface oldValue =this.context;
		this.context = context;
		firePropertyChange("context", oldValue, this.context);
	}

	public float getSize() {
		return size;
	}

	public void setSize(float size) {
		float oldValue =this.size;
		this.size = size;
		firePropertyChange("size", oldValue, this.size);
	}

	public Measure copy() {
		Measure copy=new Measure();
		copy.setContext(getContext());
		copy.setLineSegment(getLineSegment().cpy());
		copy.setDescription(getDescription());
		copy.setSize(getSize());
		return copy;
	}
	
}
