package gdxapp.Commun;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import dressing.mathutils.MathUtilities;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Line")
public class LineObject implements Serializable {
	private static final long serialVersionUID = 1L;

	public enum Property {
		START, END, MIDDLE, DIRECTOR, NORMAL,OFFSET,TMPVERTEX,ROTATION,COLOR,TMPCOLOR
	}

	private Vector2 start;
	private Vector2 end;
	private float offset=0.0f;
	private transient Vector2 tmpVertex;
	private transient Vector2 middle;
	private transient Vector2 director;
	private transient Vector2 normal;
	private transient float rotation;
	private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
	private Color color = Color.BLACK;
	private transient Color tmpcolor = Color.BLACK;

	/**
	 * Initializes new dimension line transient fields and reads its properties from
	 * <code>in</code> stream with default reading method.
	 */
	public void readObject(){
		this.propertyChangeSupport = new PropertyChangeSupport(this);
		this.tmpcolor=color;
		recalculate();
	}
	public void recalculate() {
		if(this.start != null && (this.end != null||this.tmpVertex!= null))
		{
			Vector2 end=this.end!=null?this.end:this.tmpVertex;
			this.director = end.cpy().sub(start).nor();

			this.normal = new Vector2(-director.y, director.x);

			this.middle= start.cpy().add(end).scl(0.5f);

			Vector2 v = end.cpy().sub(getStart());
			rotation = (float) Math.toDegrees(Math.acos(v.x/v.len()));
			if(getDirector().y < 0)
			{
				rotation *= -1;
			}
			firePropertyChange("recalculate", 5, 6);
			
		}
	}
	/**
	 * Adds the property change <code>listener</code> in parameter to this dimension
	 * line.
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		getPropertyChangeSupport().addPropertyChangeListener(listener);
	}

	/**
	 * Removes the property change <code>listener</code> in parameter from this
	 * dimension line.
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(listener);
	}
	public PropertyChangeSupport getPropertyChangeSupport() {
		if(propertyChangeSupport==null) {
			this.propertyChangeSupport = new PropertyChangeSupport(this);
		}
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	public void addPropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		getPropertyChangeSupport().addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(String propertyName,PropertyChangeListener listener) {
		getPropertyChangeSupport().removePropertyChangeListener(propertyName,listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,	Object newValue) {
			getPropertyChangeSupport().firePropertyChange(propertyName, oldValue,
					newValue);
					
	}
	public PropertyChangeListener[] getListeners() {
		
		return	getPropertyChangeSupport().getPropertyChangeListeners();
	}
	public void removeAllLsteners() {
		PropertyChangeListener[] listeners=getListeners();
		if(listeners==null) {
			return;
		}
		for(PropertyChangeListener listener:listeners) {
			getPropertyChangeSupport().removePropertyChangeListener(listener);
		}
	}
	
	public float getOffset() {
		return offset;
	}
	
	public void setOffset(float offset) {
		float oldValue =this.offset;
		this.offset = offset;
		firePropertyChange(Property.OFFSET.name(), oldValue, this.offset);
		recalculate();
	}
	
	public float getRotation() {
		return rotation;
	}
	public void setRotation(float rotation) {
		float oldValue =this.rotation;
		this.rotation = rotation;
		firePropertyChange(Property.ROTATION.name(), oldValue, this.rotation);
		recalculate();
	}
	public Vector2 getTmpVertex() {
		return tmpVertex;
	}
	public void setTmpVertex(Vector2 tmpVertex) {
		Vector2 oldValue =this.tmpVertex;
		this.tmpVertex = tmpVertex;
		firePropertyChange(Property.TMPVERTEX.name(), oldValue, this.tmpVertex);
		recalculate();
	}
	public Vector2 getStart() {
		return start;
	}

	public void setStart(Vector2 start) {
		Vector2 oldValue =this.start;
		this.start = start;
		firePropertyChange(Property.START.name(), oldValue, this.start);
		recalculate();
	}

	public Vector2 getEnd() {
		return end;
	}

	public void setEnd(Vector2 end) {
		Vector2 oldValue =this.end;
		this.end = end;
		firePropertyChange(Property.END.name(), oldValue, this.end);
		recalculate();
	}

	public Vector2 getMiddle() {
		return middle;
	}

	public void setMiddle(Vector2 middle) {
		Vector2 oldValue =this.middle;
		this.middle = middle;
		firePropertyChange(Property.MIDDLE.name(), oldValue, this.middle);
	}
	public Color getColor() {
		return color;
	}
	public void setColor(Color color) {
		Color oldValue =this.color;
		this.color = color;
		firePropertyChange(Property.COLOR.name(), oldValue, this.color);
	}

	public Color getTmpcolor() {
		return tmpcolor;
	}
	public void setTmpcolor(Color tmpcolor) {
		Color oldValue =this.tmpcolor;
		this.tmpcolor = tmpcolor;
		firePropertyChange(Property.TMPCOLOR.name(), oldValue, this.tmpcolor);
	}
	public Vector2 getDirector() {
		return director;
	}

	public void setDirector(Vector2 director) {
		Vector2 oldValue =this.director;
		this.director = director;
		firePropertyChange(Property.DIRECTOR.name(), oldValue, this.director);
	}

	public Vector2 getNormal() {
		return normal;
	}

	public void setNormal(Vector2 normal) {
		Vector2 oldValue =this.normal;
		this.normal = normal;
		firePropertyChange(Property.NORMAL.name(), oldValue, this.normal);
	}

	public LineObject cpy() {
		LineObject copy = new LineObject();
		copy.setStart(getStart());
		copy.setEnd(getEnd());
		copy.setTmpVertex(getTmpVertex());
		copy.setMiddle(getMiddle());
		copy.setColor(getColor());
		copy.setDirector(getDirector());
		copy.setNormal(getNormal());
		copy.setOffset(getOffset());
		
		return copy;
	}

	public boolean contains(Vector2 point, float scale) {
//		return MathUtilities.lineSegmentContainspoint(point, getStart(), getEnd(), 0.05f/scale);
		return MathUtilities.iscontains(point.x, point.y, getStart().x, getStart().y, getEnd().x, getEnd().y)
				&& MathUtilities.lineToPointDistance(point.x, point.y, getStart().x, getStart().y, getEnd().x, getEnd().y)<0.2f*scale ;
	}

	public float getLength() {
		Vector2 end = getEnd() != null ? getEnd() : getTmpVertex();
		return end.cpy().sub(getStart()).len();
	}
	
	public void reverse() {
		Vector2 aux=getStart();
		setStart(end);
		setEnd(aux);
		setOffset(-this.offset);
		recalculate();;
	}
	 
	public void setLength(float length, int direction) {
		switch(direction) {
		case 0:
			// direction = 0 , resize and keep the center
			getStart().set(this.middle.cpy().sub(this.director.cpy().scl(0.5f * length)));
			getEnd().set(this.middle.cpy().add(this.director.cpy().scl(0.5f * length)));
			break;
		case 1:
			//direction = 1 , resize and keep the start point
			getEnd().set(this.getStart().cpy().add(this.director.cpy().scl(length)));
			break;
		case -1:
			//directop = -1, resize and keep the end point
			this.getStart().set(getEnd().cpy().sub(this.director.cpy().scl(length)));
		}
		recalculate();
	}
	public void setLength(float length) {
		setLength(length, 1);
	}
}
