package gdxapp.Commun;

import java.util.ArrayList;

import com.badlogic.gdx.scenes.scene2d.Actor;

import gdxapp.object3d.Object2D;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.WorldObject;

public class GroupSelection {

	private ArrayList<Object> selection;

	private GroupSelection() {

	}

	private static GroupSelection instance;

	public void addObject(WorldObject obj) {

		getSelection().add(obj);
		obj.setSelected(true);
	}

	public boolean removeObject(Object object) {
		if (object instanceof Object2D)
		{
			((Object2D) object).getWorldObject().setSelected(false);
		}
		else if(object instanceof Object3D){
			Object3D selected = (Object3D) object;
			selected.getWorldObject().setSelected(false);
		}
		else if(object instanceof WorldObject wObject){
			wObject.setSelected(false);
		}
		return getSelection().remove(object);
	}

	public void clearSelection() {
		for (Object object : getSelection()) {
			if (object instanceof Object2D) {
				((Object2D) object).getWorldObject().setSelected(false);
			}else if (object instanceof Object3D) {
				((Object3D) object).getWorldObject().setSelected(false);
			}
			else if(object instanceof WorldObject wObject){
				wObject.setSelected(false);
			}
		}
		getSelection().clear();
	}

	public void toggleSelection(WorldObject object) {
		if (getSelection().contains(object)) {
			removeObject(object);
		} else {
			addObject(object);
		}

	}

	public Object getFirstElement() {
		if (!getSelection().isEmpty())
			return getSelection().get(0);
		return null;
	}

	public ArrayList<Object> getInstancesOf(Class<?> clazz) {
		ArrayList<Object> objects = new ArrayList<Object>();
		for (Object object : getSelection()) {
			if (object.getClass().equals(clazz)) {
				objects.add(object);
			}
		}
		return objects;
	}

	public ArrayList<Object> getSelection() {
		synchronized (GroupSelection.class) {
			if (selection == null) {
				selection = new ArrayList<Object>();
			}
			return selection;
		}
	}

	public static GroupSelection getInstance() {
		synchronized (GroupSelection.class) {
			if (instance == null) {
				instance = new GroupSelection();
			}
			return instance;
		}
	}



}
