package dressing.ui.util;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import param.Vertice3;
import param.impl.Vertice3Impl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;

public class Vertice3Composite extends Composite {

	Vertice3 vertice;
	private Text textX;
	private Text textY;
	private Text textZ;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public Vertice3Composite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		DoubleKeyAdapter adapter=new DoubleKeyAdapter();
		adapter.setMaxdotvalue(3);
		adapter.setMinvalue(0);
		adapter.setMaxvalue(1000000);

		Label lblX = new Label(this, SWT.NONE);
		lblX.setText("R");
		
		textX = new Text(this, getStyle());
		textX.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1)  );
		textX.addKeyListener(adapter);
		Label lblY = new Label(this, SWT.NONE);
		lblY.setText("G");

	
		textY = new Text(this, getStyle());
		textY.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1)  );
		textY.addKeyListener(adapter);

		Label lblZ = new Label(this, SWT.NONE);
		lblZ.setText("B");
		
		textZ = new Text(this, getStyle());
		textZ.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1)  );
		textZ.addKeyListener(adapter);

	}
	
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public Vertice3 getVertice() {
		return vertice;
	}

	public void setVertice(Vertice3 vertice) {
		if(vertice!=null) {
			this.vertice = vertice;
			this.textX.setText(String.valueOf(this.vertice.getR()));
			this.textY.setText(String.valueOf(this.vertice.getG()));
			this.textZ.setText(String.valueOf(this.vertice.getB()));
		}	
	}
	public void updateVertice() {
		this.vertice.setR(Float.valueOf(this.textX.getText()));
		this.vertice.setG(Float.valueOf(this.textY.getText()));
		this.vertice.setB(Float.valueOf(this.textZ.getText()));	
	}

	
}
