package dressing.ui.util;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject.ObjectType;
import param.MechanicDesignElment;

public class KitchenElementModelComposite extends Composite{
	
	public KitchenElement object;
	
	private Label lblFacade_2;
	private TableComboViewer tcvFacadeMtl;
	private TableComboViewer tcvBoxMtl;
	private TableComboViewer tcvBackMtl;
	
	private MaterialTypeInstanceComposite comFacadeMtlType;
	private MaterialTypeInstanceComposite comElementMtlType;
	private MaterialTypeInstanceComposite comBackMtlType;
	private Composite pieceMaterialComposite;
	
	public Map<MechanicDesignElment, DesignELementMaterialComposite> elmentMaterialsEditors=new HashMap<MechanicDesignElment, DesignELementMaterialComposite>();

	public KitchenElementModelComposite(Composite parent, int style, KitchenElement object) {
		super(parent, style);
		this.object = object;
		createContent();
	}

	public KitchenElementModelComposite(Composite parent, int style) {
		super(parent, style);
		createContent();
	}

	private void createContent() {
		setLayout(new GridLayout(8, false));
		
		lblFacade_2 = new Label(this, SWT.NONE);
		lblFacade_2.setText("Façade");
		SingleImageItemLabelProvider matLabelProvider=SingleImageItemLabelProvider.getInstance();
		tcvFacadeMtl = new TableComboViewer(this, SWT.NONE);
		TableCombo tableCombo = tcvFacadeMtl.getTableCombo();
		tableCombo.setEditable(false);
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo.defineColumns(StaticUiObjects.getMaterialColumns());
		tcvFacadeMtl.setContentProvider(ArrayContentProvider.getInstance());
		tcvFacadeMtl.setLabelProvider(matLabelProvider);
		tcvFacadeMtl.setInput(ResourceManagers.getIntance().getMaterials());
		
		comFacadeMtlType = new MaterialTypeInstanceComposite(this,SWT.NONE);
		comFacadeMtlType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		comFacadeMtlType.setSize(comFacadeMtlType.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		Label lblElement_1 = new Label(this, SWT.NONE);
		lblElement_1.setText("Element");
		
		tcvBoxMtl = new TableComboViewer(this, SWT.NONE);
		TableCombo tableCombo_1 = tcvBoxMtl.getTableCombo();
		tableCombo_1.setEditable(false);
		tableCombo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo_1.defineColumns(StaticUiObjects.getMaterialColumns());
		tcvBoxMtl.setContentProvider(ArrayContentProvider.getInstance());
		tcvBoxMtl.setLabelProvider(matLabelProvider);
 		tcvBoxMtl.setInput(ResourceManagers.getIntance().getMaterials());
		
 		comElementMtlType = new MaterialTypeInstanceComposite(this,SWT.NONE);
		comElementMtlType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		comElementMtlType.setSize(comElementMtlType.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		Label lblDos = new Label(this, SWT.NONE);
		lblDos.setText("Dos");
		
		tcvBackMtl = new TableComboViewer(this, SWT.NONE);
		TableCombo tableCombo_1_1 = tcvBackMtl.getTableCombo();
		tableCombo_1_1.setEditable(false);
		tableCombo_1_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo_1_1.defineColumns(StaticUiObjects.getMaterialColumns());
		tcvBackMtl.setContentProvider(ArrayContentProvider.getInstance());
		tcvBackMtl.setLabelProvider(matLabelProvider);
		tcvBackMtl.setInput(ResourceManagers.getIntance().getMaterials());
		//
		comBackMtlType = new MaterialTypeInstanceComposite(this,SWT.NONE);
		comBackMtlType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 6, 1));
		comBackMtlType.setSize(comBackMtlType.computeSize(SWT.DEFAULT, SWT.DEFAULT));

		//
		pieceMaterialComposite = new Composite(this, SWT.NONE);
		pieceMaterialComposite.setLayout(new GridLayout(8, false));
		pieceMaterialComposite.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 8, 1));
		setTabList(new Control[]{tableCombo, tableCombo_1, tableCombo_1_1,pieceMaterialComposite});
		
	}
	
	public void createPieceMaterialComposite(){
		if(this.object !=null) {
			if(pieceMaterialComposite!=null) {
				pieceMaterialComposite.dispose();
				redraw();
			}
			//
			pieceMaterialComposite = new Composite(this, SWT.NONE);
			pieceMaterialComposite.setLayout(new GridLayout(8, false));
			GridData gd_composite_3 = new GridData(SWT.FILL, SWT.TOP, true, false, 8, 1);
			pieceMaterialComposite.setLayoutData(gd_composite_3);
		
			//
			elmentMaterialsEditors.clear();
			if(this.object.getDesignObject()!=null) {
				for(Piece2D piece:this.object.getDesignObject().getListPieces()) {
					if(piece.getMechanicDesignElementDefinition()!=null ) {
						MechanicDesignElment element=piece.getMechanicDesignElementDefinition();
						Label	lblName = new Label(pieceMaterialComposite, SWT.NONE);
						lblName.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
						lblName.setText(element.getName());
						DesignELementMaterialComposite elementComposite=new DesignELementMaterialComposite(pieceMaterialComposite, element, SWT.BORDER);
						GridData gd_elementComposite = new GridData(SWT.FILL, SWT.CENTER, true, false, 7, 1);
						elementComposite.setLayoutData(gd_elementComposite);
						elmentMaterialsEditors.put(element,elementComposite);
					}
				}	
			}
			pieceMaterialComposite.pack();
			requestLayout();
			if(getParent() instanceof ScrolledComposite) {
				((ScrolledComposite)getParent()).setMinSize(computeSize(SWT.DEFAULT, SWT.DEFAULT));
			}

		}
		
		
	}
	
	
	

	public TableComboViewer getTcvFacadeMtl() {
		return tcvFacadeMtl;
	}

	public void setTcvFacadeMtl(TableComboViewer tcvFacadeMtl) {
		this.tcvFacadeMtl = tcvFacadeMtl;
	}

	public TableComboViewer getTcvBoxMtl() {
		return tcvBoxMtl;
	}

	public void setTcvBoxMtl(TableComboViewer tcvBoxMtl) {
		this.tcvBoxMtl = tcvBoxMtl;
	}

	public TableComboViewer getTcvBackMtl() {
		return tcvBackMtl;
	}

	public void setTcvBackMtl(TableComboViewer tcvBackMtl) {
		this.tcvBackMtl = tcvBackMtl;
	}

	public MaterialTypeInstanceComposite getComFacadeMtlType() {
		return comFacadeMtlType;
	}

	public void setComFacadeMtlType(MaterialTypeInstanceComposite comFacadeMtlType) {
		this.comFacadeMtlType = comFacadeMtlType;
	}

	public MaterialTypeInstanceComposite getComElementMtlType() {
		return comElementMtlType;
	}

	public void setComElementMtlType(MaterialTypeInstanceComposite comElementMtlType) {
		this.comElementMtlType = comElementMtlType;
	}

	public MaterialTypeInstanceComposite getComBackMtlType() {
		return comBackMtlType;
	}

	public void setComBackMtlType(MaterialTypeInstanceComposite comBackMtlType) {
		this.comBackMtlType = comBackMtlType;
	}

	public Composite getPieceMaterialComposite() {
		return pieceMaterialComposite;
	}

	public void setPieceMaterialComposite(Composite pieceMaterialComposite) {
		this.pieceMaterialComposite = pieceMaterialComposite;
	}

	public KitchenElement getObject() {
		return object;
	}

	public void setObject(KitchenElement object) {
		this.object = object;
	}

	public Map<MechanicDesignElment, DesignELementMaterialComposite> getElmentMaterialsEditors() {
		return elmentMaterialsEditors;
	}

	public void setElmentMaterialsEditors(
			Map<MechanicDesignElment, DesignELementMaterialComposite> elmentMaterialsEditors) {
		this.elmentMaterialsEditors = elmentMaterialsEditors;
	}
	
	
	
	
	

	
}
