package dressing.ui.util;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Spinner;

import dressing.model.ModelProvider;
import dressing.model.Space3D;
import dressing.model.types.PoigneePosition;
import dressing.model.types.PortType;
import dressing.model.types.PorteDirection;
import dressing.ui.ChangeCommand;
import dressing.ui.CommandStack;
import dressing.ui.DesignChangeParamCommand;
import gdxapp.Commun.AbstractScreen;
import gdxapp.object3d.KitchenElement;
import gdxapp.scenes.Scene;
import param.MaterialTypeInstance;
import param.MechanicDesign;
import param.MechanicPublicParam;
import param.TypeDefElement;

public class FacadeConfigComposite extends Composite {

	private ComboViewer comboViewer_PorteType;
	private ComboViewer comboViewer_PorteDirection;
	private ComboViewer comboViewer_FacadeType;
	private MaterialTypeInstanceComposite vitreMaterialType;
	private Spinner spnVitreBandeL;
	private Composite pieceFacadeTypeComposite;
	private KitchenElement kitchenElement;
	private MechanicDesign design;
	
	TypeDefElement porteType = null;
	TypeDefElement porteDirection = null;


	
	ISelectionChangedListener selectionListener = new ISelectionChangedListener() {
		public void selectionChanged(SelectionChangedEvent event) {
			if (validate(event.getSource())) {
				CommandStack command = updateObject();
				if (command != null) {
					if (((AbstractScreen) Scene.game.getScreen()).getController()
							.getChangeCommandController() != null) {
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
								.addCommand(command);
					}

				}
			} else {
				//
				if (event.getSource().equals(comboViewer_PorteType) && porteType != null) {
					comboViewer_PorteType.setSelection(new StructuredSelection(porteType), true);
				}
				if (event.getSource().equals(comboViewer_PorteDirection) && porteDirection != null) {
					comboViewer_PorteDirection.setSelection(new StructuredSelection(porteDirection), true);
				}
			}

		}
	};
	
	Listener controlListener = new Listener() {
		@Override
		public void handleEvent(Event event) {
			CommandStack command = updateObject();
			if (command != null) {
				if (((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController() != null) {
					((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
							.addCommand(command);
				}
			}
		}
	};
	Listener keyUpListener = new Listener() {
		@Override
		public void handleEvent(Event event) {
			if (event.keyCode == SWT.CR || event.keyCode == SWT.KEYPAD_CR) {
				CommandStack command = updateObject();
				if (command != null) {
					if (((AbstractScreen) Scene.game.getScreen()).getController()
							.getChangeCommandController() != null) {
						((AbstractScreen) Scene.game.getScreen()).getController().getChangeCommandController()
								.addCommand(command);
					}
				}
			}
		}
	};
	
	

	public FacadeConfigComposite(Composite parent, int style) {
		super(parent, style);
	}

	public void createContent() {
		Label lblTypePorte = new Label(this, SWT.NONE);
		GridData gd_lblTypePorte = new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1);
		gd_lblTypePorte.widthHint = 60;
		lblTypePorte.setLayoutData(gd_lblTypePorte);
		lblTypePorte.setText("Type");
		comboViewer_PorteType = new ComboViewer(this, SWT.READ_ONLY);
		Combo combo_PorteType = comboViewer_PorteType.getCombo();
		combo_PorteType.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		comboViewer_PorteType.setContentProvider(TypeDefContentProvider.getInstance());
		comboViewer_PorteType.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		Label lblDirection = new Label(this, SWT.NONE);
		lblDirection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		lblDirection.setText("Direction");
		comboViewer_PorteDirection = new ComboViewer(this, SWT.READ_ONLY);
		Combo combo_PorteDirection = comboViewer_PorteDirection.getCombo();
		combo_PorteDirection.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_PorteDirection.setContentProvider(TypeDefContentProvider.getInstance());
		comboViewer_PorteDirection.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		Label lblFacade_1 = new Label(this, SWT.NONE);
		lblFacade_1.setText("Type Façade");
		comboViewer_FacadeType = new ComboViewer(this, SWT.READ_ONLY);
		Combo combo_FacadeType = comboViewer_FacadeType.getCombo();
		combo_FacadeType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_FacadeType.setContentProvider(TypeDefContentProvider.getInstance());
		comboViewer_FacadeType.setLabelProvider(TypeDefElementLabelProvider.getInstance());
		//
		Label lblMaterialType = new Label(this, SWT.NONE);
		lblMaterialType.setText("Type Matérieaux du vitre");
		vitreMaterialType = new MaterialTypeInstanceComposite(this, SWT.NONE);
		vitreMaterialType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		vitreMaterialType.setSize(vitreMaterialType.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		//
		Label lblVitreBandeL = new Label(this, SWT.NONE);
		lblVitreBandeL.setText("Vitre Bande");
		spnVitreBandeL = new Spinner(this, SWT.BORDER);
		spnVitreBandeL.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnVitreBandeL.setMaximum(100000000);
		spnVitreBandeL.setMinimum(20);
		//
		//
		pieceFacadeTypeComposite = new Composite(this, SWT.NONE);
		pieceFacadeTypeComposite.setLayout(new GridLayout(6, false));
		pieceFacadeTypeComposite.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1));
		//
		this.setTabList(new Control[] { combo_PorteType, combo_PorteDirection, combo_FacadeType,
				vitreMaterialType, pieceFacadeTypeComposite });

	}
	
	public void createControlForDesign() {
		if(design == null)
			return;
		DesignControlCreationHelper.createControlForIntegerParams(design,"vitre.bandeL", spnVitreBandeL);
		DesignControlCreationHelper.createControlForTypeParams(design, "PORTE_TYPE", comboViewer_PorteType);
		DesignControlCreationHelper.createControlForTypeParams(this.design, "PORTE_DIRECTION", comboViewer_PorteDirection);
		DesignControlCreationHelper.createControlForTypeParams(this.design, "FACADE_TYPE", comboViewer_FacadeType);
		//
		if (design.getDefaultVitreMaterialType() != null) {
			vitreMaterialType.setMaterial(design.getDefaultVitreMaterialType());
			vitreMaterialType.setEnabled(true);
		} else {
			vitreMaterialType.setEnabled(false);
		}

	}
	
	public void setInput() {
		comboViewer_PorteType.setInput(ModelProvider.getTypeDef("PORTE_TYPE"));
		comboViewer_PorteDirection.setInput(ModelProvider.getTypeDef("PORTE_DIRECTION"));
		comboViewer_FacadeType.setInput(ModelProvider.getTypeDef("FACADE_TYPE"));
	}
	
	public void addListeners() {
		//
		if (spnVitreBandeL.isEnabled()) {
			spnVitreBandeL.addListener(SWT.FocusOut, controlListener);
			spnVitreBandeL.addListener(SWT.KeyUp, keyUpListener);
		}
		//
		if (comboViewer_PorteType.getControl().isEnabled()) {
			comboViewer_PorteType.addSelectionChangedListener(selectionListener);
		}
		if (comboViewer_PorteDirection.getControl().isEnabled()) {
			comboViewer_PorteDirection.addSelectionChangedListener(selectionListener);
		}
		if (comboViewer_FacadeType.getControl().isEnabled()) {
			comboViewer_FacadeType.addSelectionChangedListener(selectionListener);
		}
	}
	
	public void removeListeners() {
		spnVitreBandeL.removeListener(SWT.KeyUp, keyUpListener);
		spnVitreBandeL.removeListener(SWT.FocusOut, controlListener);
		comboViewer_PorteType.removeSelectionChangedListener(selectionListener);
		comboViewer_PorteDirection.removeSelectionChangedListener(selectionListener);
		comboViewer_FacadeType.removeSelectionChangedListener(selectionListener);
		
		porteDirection = null;

	}
	
	
	public CommandStack updateObject() {
		boolean changed = false;
		boolean poigneePosChanged = false;
		PorteDirection porteDir = null;


		
		CommandStack stack = new CommandStack("change from facade tab in measures window", "change from window",
				new ArrayList<ChangeCommand>());
		try {
			MechanicPublicParam paramVitreBandeL = this.design.getPublicParam("vitre.bandeL");
			if (paramVitreBandeL != null && spnVitreBandeL.isEnabled()) {
				String r = paramVitreBandeL.getDefaultvalue();
				int retrait = Integer.valueOf(r);
				int spnretrait = spnVitreBandeL.getSelection();
				if (retrait != spnretrait) {
					paramVitreBandeL.setDefaultvalue(String.valueOf(spnretrait));
					changed = true;
					DesignChangeParamCommand paramVitreBandeLChange = new DesignChangeParamCommand(
							"Changer la position du poigner" + design.getName(), "move",
							this.kitchenElement, "vitre.bandeL", true, r, String.valueOf(spnretrait));
					stack.addCommand(paramVitreBandeLChange);
				}
			}
			
			MechanicPublicParam paramPorteType = this.kitchenElement.getDesignObject().getElementPorteType();
			if (paramPorteType != null && comboViewer_PorteType.getControl().isEnabled()) {
				TypeDefElement porteType = paramPorteType.getTypedefelement();
				IStructuredSelection selection = comboViewer_PorteType.getStructuredSelection();
				Object se = selection.getFirstElement();
				if (se != null && se instanceof TypeDefElement) {
					TypeDefElement sporteType = (TypeDefElement) se;
					if (sporteType != porteType) {
						this.porteType = sporteType;
						changed = true;
						paramPorteType.setTypedefelement(sporteType);
						//
						DesignChangeParamCommand poignerChange = new DesignChangeParamCommand(
								"Changer le Type du porte" + this.kitchenElement.getName(), "move",
								this.kitchenElement, "PORT_TYPE", true, porteType, sporteType);
						stack.addCommand(poignerChange);

						//
					}
				}
			}
			
			//
			MechanicPublicParam paramPorteDirection = this.kitchenElement.getDesignObject().getElementPorteDirection();
			if (paramPorteDirection != null && comboViewer_PorteDirection.getControl().isEnabled()) {
				TypeDefElement porteDirection = paramPorteDirection.getTypedefelement();
				IStructuredSelection selection = comboViewer_PorteDirection.getStructuredSelection();
				Object se = selection.getFirstElement();
				if (se != null && se instanceof TypeDefElement) {
					TypeDefElement sporteDirection = (TypeDefElement) se;
					if (sporteDirection != porteDirection) {
						this.porteDirection = sporteDirection;
						changed = true;
						paramPorteDirection.setTypedefelement(sporteDirection);
						//
						DesignChangeParamCommand poignerChange = new DesignChangeParamCommand(
								"Changer le direction du porte" + this.kitchenElement.getName(), "move",
								this.kitchenElement, "PORT_TYPE", true, porteDirection, sporteDirection);
						stack.addCommand(poignerChange);

						//
					} else {
						if (poigneePosChanged && porteDir != null) {
							PorteDirection spoteDir = PorteDirection.valueOf(sporteDirection.getKey());
							if (porteDir != spoteDir) {
								TypeDefElement value = paramPorteDirection.getTypedef().getElement(porteDir.name());
								paramPorteDirection.setTypedefelement(value);
								this.porteDirection = value;
								comboViewer_PorteDirection.setSelection(new StructuredSelection(value));
								//
								DesignChangeParamCommand poignerChange = new DesignChangeParamCommand(
										"Changer le direction du porte" + this.kitchenElement.getName(), "move",
										this.kitchenElement, "PORT_TYPE", true, porteDirection, value);
								stack.addCommand(poignerChange);

								//
							}

						}
					}
				}
			}
			
			//
			try {
				MechanicPublicParam paramFacadeType = this.design.getPublicParam("FACADE_TYPE");
				if (paramFacadeType != null && comboViewer_FacadeType.getControl().isEnabled()) {
					TypeDefElement typeFacade = paramFacadeType.getTypedefelement();
					IStructuredSelection selection = comboViewer_FacadeType.getStructuredSelection();
					Object se = selection.getFirstElement();
					if (se != null && se instanceof TypeDefElement) {
						TypeDefElement sFacadeType = (TypeDefElement) se;
						if (sFacadeType != typeFacade) {
							changed = true;
							paramFacadeType.setTypedefelement(sFacadeType);
							DesignChangeParamCommand changerParamtype = new DesignChangeParamCommand(
									"Changer le type de façade" + this.kitchenElement.getName(), "type de façade",
									this.kitchenElement, "FACADE_TYPE", true, typeFacade, sFacadeType);
							stack.addCommand(changerParamtype);
						}
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			
			//
			if (this.vitreMaterialType.isDirty()) {
				MaterialTypeInstance material = vitreMaterialType.getMaterial();
				MaterialTypeInstance vitreMaterialType = design.getDefaultVitreMaterialType();
				vitreMaterialType.setIsColor(material.isIsColor());
				vitreMaterialType.setMaterial(material.getMaterial());
				vitreMaterialType.setTexture(this.vitreMaterialType.getSelectedTexture());
				if (this.vitreMaterialType.getColorComposite().isDirty()) {
					vitreMaterialType.setColor(this.vitreMaterialType.getColorComposite().getEmfColor());
				}
				changed = true;
			}
		} catch (Exception e) {
			MessageBox dialog = new MessageBox(getParent().getShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
			dialog.setText("Error");
			dialog.setMessage("un erreur est servenue lors de mise à jour du model à cause de :" + e.getMessage());
			// open dialog and await user selection
			dialog.open();
			e.printStackTrace();
		}
		return stack;
	}
	
	public boolean validate(Object object2) {
		boolean valid = true;
		
		Space3D space = (Space3D) this.kitchenElement.getDesignObject();
		
		PortType portType = null;
		PorteDirection porteDirection = null;
		PoigneePosition pos = null;
		//
		IStructuredSelection selectionPorteType = comboViewer_PorteType.getStructuredSelection();
		Object sPorteType = selectionPorteType.getFirstElement();

		if (sPorteType != null && sPorteType instanceof TypeDefElement) {
			TypeDefElement sPorteTypes = (TypeDefElement) sPorteType;
			portType = PortType.valueOf(sPorteTypes.getKey());
		}
		if (object2 != null && object2.equals(comboViewer_PorteType) && portType != null) {
			String caissonType = space.getDesignCaissonType();
			if ((portType.equals(PortType.BASCULANT) || portType.equals(PortType.BASCULANT2H))
					&& (!caissonType.contentEquals("HAUT") || space.getName().toUpperCase().contains("NICHE"))) {
				valid = false;
				MessageBox dialog = new MessageBox(getShell(), SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
				dialog.setText("Error");
				dialog.setMessage("impossible de faire la combinaison de porte " + portType.toString()
						+ " avec la porte en direction " + space.getName());
				// open dialog and await user selection
				dialog.open();
			}
		}
		if (object2 != null && object2.equals(comboViewer_PorteDirection)) {
			if (porteDirection != null && pos != null) {
				if (portType != null && portType.equals(PortType.FRANCAISE)
						&& kitchenElement.getDesignObject().getLongeurext() <= 600) {
					switch (pos) {
					case BOTTOM_LEFT:
					case TOP_LEFT:
					case LEFT_MIDDLE:
						if (porteDirection.equals(PorteDirection.RIGHT)) {
							valid = false;
						}

						break;
					case BOTTOM_RIGHT:
					case TOP_RIGHT:
					case RIGHT_MIDDLE:
						if (porteDirection.equals(PorteDirection.LEFT)) {
							valid = false;
						}
						break;

					default:
						break;
					}

					if (!valid) {
						MessageBox dialog = new MessageBox(getShell(),
								SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
						dialog.setText("Error");
						dialog.setMessage("impossible de faire la combinaison de poignee " + pos.toString()
								+ " avec la porte en direction " + porteDirection.toString());
						// open dialog and await user selection
						dialog.open();
					}
				}
			}
		}
		
		//
		IStructuredSelection selectionPorteDirction = comboViewer_PorteDirection.getStructuredSelection();
		Object sPorteDirection = selectionPorteDirction.getFirstElement();

		if (sPorteDirection != null && sPorteDirection instanceof TypeDefElement) {
			TypeDefElement sPorteDirections = (TypeDefElement) sPorteDirection;
			porteDirection = PorteDirection.valueOf(sPorteDirections.getKey());

		}

		return valid;
	}

	public ComboViewer getComboViewer_PorteType() {
		return comboViewer_PorteType;
	}

	public ComboViewer getComboViewer_PorteDirection() {
		return comboViewer_PorteDirection;
	}

	public ComboViewer getComboViewer_FacadeType() {
		return comboViewer_FacadeType;
	}

	public MaterialTypeInstanceComposite getVitreMaterialType() {
		return vitreMaterialType;
	}

	public Spinner getSpnVitreBandeL() {
		return spnVitreBandeL;
	}

	public Composite getPieceFacadeTypeComposite() {
		return pieceFacadeTypeComposite;
	}


	public KitchenElement getKitchenElement() {
		return kitchenElement;
	}

	public void setKitchenElement(KitchenElement kitchenElement) {
		this.kitchenElement = kitchenElement;
		this.design = this.kitchenElement.getDesignObject().getMechanicDesignDefinition();
	}


	
	
	
	

	
	
	



	
	
	
	

}
