package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Text;

public class DoubleKeyAdapter extends KeyAdapter {
	private int maxvalue=10000;
	private int maxdotvalue=3;
	private int minvalue=0;

	
	
	@Override
	public void keyPressed(KeyEvent e) {
		if(!checkmaximum(e,(Text) e.widget)) {
			e.doit=false;
			return;
		}else {
			e.doit=checkmaximum(e,(Text) e.widget);
		}
		try {
			char string = e.character;
			int str=e.keyCode;
			if(string=='.') {
				 
				((Text) e.widget).setSelection(((Text) e.widget).getCaretPosition());

	
		            if(((Text) e.widget).getText().contains(".")) {
		            	e.doit = false;
			            return;
		            }
		                
			}
			if ((('0' <= string && string <= '9') || string == '.' || string == '	' || string == SWT.DEL
					|| string == SWT.TAB||str == SWT.ARROW_LEFT|| str== SWT.ARROW_RIGHT  ||string == SWT.CR||string == SWT.BS)) {
				e.doit = true;						
				return;
			} else {
				
				e.doit = false;
				return;
			}
			
		} catch (StringIndexOutOfBoundsException | java.lang.IllegalArgumentException e1) {
			e.doit=false;
		}
		// as a result of processing the above call, clients may have
		// disposed this cell editor
		if (((Text) e.widget) == null || ((Text) e.widget).isDisposed()) {
			return;
		}
		
	}
	private boolean checkmaximum(KeyEvent e,Text text) {
		
		String str="";
		String str2="";
		double str1=0;
		String txt;
		char string = e.character;
		if ('0' <= string && string <= '9') {
			 txt=text.getText().substring(0, text.getCaretPosition())
					+e.character+text.getText().substring(text.getCaretPosition());
		}else {
			txt=text.getText();
		}
		if(txt.indexOf(".")!=-1) {
			 str=txt.substring(0, txt.indexOf("."));
			 str2=txt.substring(txt.indexOf(".")+1);
		}else {
			 str=txt.substring(0);
		}
		if(!str.isEmpty()) {
			 str1=Double.parseDouble(str);
		}
		
		if(str1>maxvalue || str2.length()>maxdotvalue || str1<minvalue) {
			return false;
		}else {
			return true;
		}
		
	}
	public int getMaxvalue() {
		return maxvalue;
	}
	public void setMaxvalue(int maxvalue) {
		this.maxvalue = maxvalue;
	}
	public int getMaxdotvalue() {
		return maxdotvalue;
	}
	public void setMaxdotvalue(int maxdotvalue) {
		this.maxdotvalue = maxdotvalue;
	}
	public int getMinvalue() {
		return minvalue;
	}
	public void setMinvalue(int minvalue) {
		this.minvalue = minvalue;
	}
	
}
