package dressing.ui.usinage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.inject.Inject;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.config.WorkspaceConfiguration;
import dressing.config.persistence.ResourceManagers;
import dressing.model.DesignException;
import dressing.model.ModelProvider;
import dressing.ui.TexturesComposite;
import dressing.ui.util.DoubleCellEditor;
import param.Material;
import param.MaterialGroup;
import param.impl.MaterialImpl;
import param.impl.ParamFactoryImpl;

public class MaterialEditorComposite extends Composite {
	private Table table;
	MaterialGroup materieaux= ResourceManagers.getIntance().getMaterialGroup();
	TableViewer tableViewer;
	private MDirtyable dirty;
	
	private EHandlerService handlerService;
	
	
	private ECommandService commandService;
	
	IEventBroker eventBroker;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public MaterialEditorComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new FillLayout(SWT.HORIZONTAL));
		
		 tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());
		
		
		TableViewerColumn tableViewerColumnName = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnName.setEditingSupport(new EditingSupport(tableViewer) {
			TextCellEditor cellEditor=new TextCellEditor(table);
			protected boolean canEdit(Object element) {
				// TODO Auto-generated method stub
				return true;
			}
			protected CellEditor getCellEditor(Object element) {
				// TODO Auto-generated method stub
				return cellEditor;
			}
			protected Object getValue(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getName();
				}
				return null;
			}
			protected void setValue(Object element, Object value) {
				if(element !=null && element instanceof Material &&!((Material)element).getName().contentEquals((String) value)) {
					((Material)element).setName((String) value);
					cellEditor.setValue(value);
					table.update();
					tableViewer.refresh();
					dirty.setDirty(true);
				}
			}
		});
		tableViewerColumnName.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getName();
				}
				return element == null ? "" : element.toString();
			}
		});

		TableColumn tblclmnName = tableViewerColumnName.getColumn();
		tblclmnName.setWidth(100);
		tblclmnName.setText("Nom");
		
		TableViewerColumn tableViewerEpaisseur = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerEpaisseur.setEditingSupport(new EditingSupport(tableViewer) {
			DoubleCellEditor cellEditor=new DoubleCellEditor(table);
			protected boolean canEdit(Object element) {
				// TODO Auto-generated method stub
				return true;
			}
			protected CellEditor getCellEditor(Object element) {
				// TODO Auto-generated method stub
				return cellEditor;
			}
			protected Object getValue(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getEpaisseur();
				}
				return null;
			}
			protected void setValue(Object element, Object value) {
				if(element !=null && element instanceof Material &&((Material)element).getEpaisseur()!=Double.valueOf((String) value)) {
					double val=0.0;
					if(value instanceof Double) {
						val=(double) value;
					}else if(value instanceof String ) {
						value=Double.valueOf((String) value);
					}
					((Material)element).setEpaisseur((double)value);
					cellEditor.setValue(value);
					table.update();
					tableViewer.refresh();
					dirty.setDirty(true);
					
				}
			}
		});
		tableViewerEpaisseur.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return String.valueOf(((Material)element).getEpaisseur());
				}
				return element == null ? "" : element.toString();
			}
		});
		TableColumn tblclmnEpaisseur = tableViewerEpaisseur.getColumn();
		tblclmnEpaisseur.setWidth(50);
		tblclmnEpaisseur.setText("Epaisseur");
		TableViewerColumn tableViewerClmnImage = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerClmnImage.setEditingSupport(new EditingSupport(tableViewer) {
			TextCellEditor cellEditor=new TextCellEditor(table);
			protected boolean canEdit(Object element) {
				// TODO Auto-generated method stub
				return true;
			}
			protected CellEditor getCellEditor(Object element) {
				// TODO Auto-generated method stub
				return cellEditor;
			}
			protected Object getValue(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getImage();
				}
				return null;
			}
			protected void setValue(Object element, Object value) {
				if(element !=null && element instanceof Material &&!((Material)element).getImage().contentEquals((String) value)) {
					
					((Material)element).setImage((String) value);
					cellEditor.setValue(value);
					table.update();
					tableViewer.refresh();
					dirty.setDirty(true);
				}
			}
		});
		tableViewerClmnImage.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				try {
					File image=WorkspaceConfiguration.getimage("pictures/" +  ((Material)element).getImage(), true,table.getDisplay());
					if(image.exists()) {
						Image image1=new Image(table.getDisplay(), new FileInputStream(image));
						ImageDescriptor descriptor = ImageDescriptor.createFromImage(image1);
						ResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
						Image im = rsmanager.createImage(descriptor);
						Image scaled216 = new Image(parent.getDisplay(), im.getImageData().scaledTo(128, 32));
						return scaled216;

					}
				
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Material ) {
					return ((Material)element).getImage();
				}
				return element == null ? "" : element.toString();
			}
		});
		TableColumn tblclmnImage = tableViewerClmnImage.getColumn();
		tblclmnImage.setWidth(290);
		tblclmnImage.setText("Texture");
		tableViewer.setInput(materieaux.getMaterial());
		ControlAdapter cal= new ControlAdapter() {
			
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = MaterialEditorComposite.this.getClientArea();
		      Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*table.getBorderWidth();
		      if (preferredSize.y > area.width + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		       
		      }
		      Point vBarSize = table.getVerticalBar().getSize();
		        width -= vBarSize.x;
		      Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		    	tblclmnName.setWidth(width/3);
		        tblclmnEpaisseur.setWidth(width/6);
		        tblclmnImage.setWidth(width/2);
		        table.setSize(area.width, area.height-30);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		        table.setSize(area.width, area.height-30);
		        tblclmnName.setWidth(width/3);
		        tblclmnEpaisseur.setWidth(width/6);
		        tblclmnImage.setWidth(width/2);

		      }
		    }};
		    this.addControlListener(cal);
			table.setLinesVisible(true);
			MenuManager menuMgr = new MenuManager();

	        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
	        menuMgr.addMenuListener(new IMenuListener() {
				
				@Override
				public void menuAboutToShow(IMenuManager manager) {
					// TODO Auto-generated method stub
					manager.add(new Action("Dupliquer") {
	                	public void run() {
	        					Object selection=tableViewer.getStructuredSelection().getFirstElement();
	        					if(selection!=null && selection instanceof MaterialImpl) {
	        						MaterialImpl origin=(MaterialImpl) selection;
	        						
	        					    MaterialImpl copy = (MaterialImpl) ParamFactoryImpl.eINSTANCE.createMaterial();
	        					    copy.setEpaisseur(origin.getEpaisseur());
	        					    copy.setImage(origin.getImage());
	        					    copy.setName(origin.getName());
	        					    materieaux.getMaterial().add(copy);
	        					    table.update();
	        						tableViewer.refresh();
	        						dirty.setDirty(true);
	        					}
	                	};
					});
					manager.add(new Action("Supprimer") {
	                	public void run() {
	        					Object selection=tableViewer.getStructuredSelection().getFirstElement();
	        					if(selection!=null && selection instanceof MaterialImpl) {
	        						MaterialImpl origin=(MaterialImpl) selection;
	        						   
	        					    materieaux.getMaterial().remove(origin);
	        					    table.update();
	        						tableViewer.refresh();
	        						dirty.setDirty(true);
	        					}
	                	};
					});
					manager.add(new Action("Ajouter un frère") {
	                	public void run() {

							MaterialImpl copy = (MaterialImpl) ParamFactoryImpl.eINSTANCE.createMaterial();
							copy.setEpaisseur(0.0);
							copy.setImage("ITALIAN POPLAR.jpg");
							copy.setName("Nom");
							materieaux.getMaterial().add(copy);
							table.update();
							tableViewer.refresh();
							dirty.setDirty(true);	
	                	};
					});
					manager.add(new Action("Coller") {
	                	public void run() {
	        					Clipboard clipboard = new Clipboard(Display.getCurrent());
	        		    	    TextTransfer textTransfer = TextTransfer.getInstance();
	        		    	    String data=(String) clipboard.getContents(textTransfer);
	        		    	    Object selection=tableViewer.getStructuredSelection().getFirstElement();
	        					if(selection!=null && selection instanceof MaterialImpl) {
	        						MaterialImpl origin=(MaterialImpl) selection;
	        						origin.setImage(data);
	        					}	
	        		    	    clipboard.dispose();
	        		    	    table.update();
								tableViewer.refresh();
								dirty.setDirty(true);
	                	};
					});
				}
			});
	        menuMgr.setRemoveAllWhenShown(true);
	        tableViewer.getControl().setMenu(menu);
			tableViewer.refresh();
			table.pack();
		
		
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public Table getTable() {
		return table;
	}
	public void refresh() {
		if(!table.isDisposed() && tableViewer!=null) {
			table.update();
			tableViewer.refresh();
		}
	}
	public void setTable(Table table) {
		this.table = table;
	}

	public MaterialGroup getMaterieaux() {
		return materieaux;
	}

	public void setMaterieaux(MaterialGroup materieaux) {
		this.materieaux = materieaux;
	}

	public TableViewer getTableViewer() {
		return tableViewer;
	}

	public void setTableViewer(TableViewer tableViewer) {
		this.tableViewer = tableViewer;
	}

	public MDirtyable getDirty() {
		return dirty;
	}

	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	
	public EHandlerService getHandlerService() {
		return handlerService;
	}

	public void setHandlerService(EHandlerService handlerService) {
		this.handlerService = handlerService;
	}

	public ECommandService getCommandService() {
		return commandService;
	}

	public void setCommandService(ECommandService commandService) {
		this.commandService = commandService;
	}
	public IEventBroker getEventBroker() {
		return eventBroker;
	}

	public void setEventBroker(IEventBroker eventBroker) {
		this.eventBroker = eventBroker;
	}
	public void run() throws DesignException {
		ResourceManagers.getIntance().saveLibraryResource();
		dirty.setDirty(false);
	}
	
	
	public void cancel() {
		
		tableViewer.refresh();
		ResourceManagers.getIntance().saveLibraryResource();
		dirty.setDirty(false);
	}


}
