package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.ui.util.ColorComposite;
import gdxapp.object3d.PlinthObject;
import gdxapp.scenes.SceneEvent;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class SocleSettingComposite extends Composite{

	private PlinthObject plinthObject;
	private float initialHeight;
	private float initialThickness;
	private Vector3 initialColor;
	private Runnable onFinish;
	
	//ui attr
	private Spinner heightSpinner;
	private Spinner thicknessSpinner;
	private ColorComposite colorComposite;
	//
	private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
	PropertyChangeListener colorListener = new PropertyChangeListener() {
		
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
				RGB rgb = (RGB) evt.getNewValue();
				Vector3 albedo = new Vector3(rgb.red / 255.0f, rgb.green/255.0f,rgb.blue / 255.0f);
				if(plinthObject != null) {
					plinthObject.getGeometry().getBorder().getMaterial().setAlbedo(albedo);
					pcs.firePropertyChange("color", null , albedo);
					EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
				}
				
		}
	};
	

	public SocleSettingComposite(Composite parent, int style, PlinthObject plinthObject, Runnable onFinish, boolean displayButton) {
		super(parent, style);
		this.plinthObject = plinthObject;
		this.onFinish = onFinish;
		saveInitialValue();
		setLayout(new GridLayout(2, false));
		
		Label lblHauteur = new Label(this, SWT.NONE);
		lblHauteur.setText("Hauteur: ");
		
		heightSpinner = new Spinner(this, SWT.BORDER);
		heightSpinner.setMaximum(2500);
		heightSpinner.setMinimum(10);
		heightSpinner.setSelection(Math.round(plinthObject.getHeight() * 1000));
		heightSpinner.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float height = heightSpinner.getSelection()/1000.0f;
				plinthObject.setHeight(height);
				pcs.firePropertyChange("height", null , height);
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
			}
		});
		heightSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEpaisseur = new Label(this, SWT.NONE);
		lblEpaisseur.setText("Épaisseur: ");
		
		thicknessSpinner = new Spinner(this, SWT.BORDER);
		thicknessSpinner.setMinimum(10);
		thicknessSpinner.setMaximum(2500);
		thicknessSpinner.setSelection(Math.round(plinthObject.getThickness() * 1000));
		thicknessSpinner.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				plinthObject.setThickness(thicknessSpinner.getSelection() / 1000.0f);
				pcs.firePropertyChange("thickness", null , plinthObject.getThickness());
				EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
			}
		});
		thicknessSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblCouleur = new Label(this, SWT.NONE);
		lblCouleur.setText("Couleur: ");
		
		colorComposite = new ColorComposite(this, SWT.NONE);
		colorComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		colorComposite.addColorListener(this.colorListener);
		
		colorComposite.setColor(plinthObject.getGeometry().getBorder().getMaterial().getAlbedo());
		
		Composite compositeButtons = new Composite(this, SWT.NONE);
		compositeButtons.setLayout(new GridLayout(2, false));
		GridData buttonCmpGD = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
		compositeButtons.setLayoutData(buttonCmpGD);
		
		Button btnAnnuler = new Button(compositeButtons, SWT.NONE);
		btnAnnuler.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				cancel();
			}
		});
		btnAnnuler.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false, 1, 1));
		btnAnnuler.setBounds(0, 0, 90, 30);
		btnAnnuler.setText("Annuler");
		
		Button btnModifier = new Button(compositeButtons, SWT.NONE);
		btnModifier.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				modify();
			}
		});
		btnModifier.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		btnModifier.setText("Modifier");
		
		buttonCmpGD.exclude = !displayButton;
		
	}
	
	public void addListener(PropertyChangeListener llistener) {
		this.pcs.addPropertyChangeListener(llistener);
	}
	public void saveInitialValue() {
		this.initialHeight = plinthObject.getHeight();
		this.initialThickness = plinthObject.getThickness();
		this.initialColor = plinthObject.getGeometry().getBorder().getMaterial().getAlbedo();
	}
	
	void cancel() {
		if(changed()) {
			plinthObject.setHeight(initialHeight);
			plinthObject.setThickness(initialThickness);
			plinthObject.getGeometry().getBorder().getMaterial().setAlbedo(initialColor);
			plinthObject.setRequireRefrech(true);
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
		}
		if(onFinish != null)
			onFinish.run();
	}
	
	void modify() {
		if(changed()) {
			plinthObject.setRequireRefrech(true);
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), plinthObject));
		}
		if(onFinish != null)
			onFinish.run();
	}
	
	public boolean changed() {
		boolean changed = Math.abs(initialHeight - plinthObject.getHeight())> 0.001;
		changed |= Math.abs(initialHeight - plinthObject.getHeight())> 0.001;
		changed |= !initialColor.epsilonEquals(plinthObject.getColor(), 0.001f);
		return changed;
	}
	
	public boolean hasValidInput() {
		return colorComposite.getColor() != null && heightSpinner.getSelection() >= 50 && thicknessSpinner.getSelection() >=18;
	}

	@Override
	public void dispose() {
		super.dispose();
		Arrays.asList(pcs.getPropertyChangeListeners()).forEach((l) -> pcs.removePropertyChangeListener(l));
		
	}
	
	
	
}
