package dressing.ui.project;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

import javax.swing.JPanel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

import com.badlogic.gdx.math.Vector2;

import dressing.controller.KitchenShapeBuilder;
import dressing.controller.ProjectCreator;
import dressing.mathutils.MathUtilities;
import geometry.Polygon;

public class KitchenDraw2D extends Composite {
	
	KitchenShapeBuilder shapeBuilder;
	private Panel2D panel2D;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public KitchenDraw2D(Composite parent, int style,KitchenShapeBuilder shapeBuilder) {
		super(parent, SWT.EMBEDDED);
		this.shapeBuilder= shapeBuilder;

		java.awt.Frame frame = SWT_AWT.new_Frame(this);
		javax.swing.JPanel panel = new javax.swing.JPanel();
		frame.add(panel);
		//add canvas
		panel.setLayout(new BorderLayout());
		
		panel.setSize(SWT.MAX, SWT.MAX);
		panel2D = new Panel2D(shapeBuilder);
		panel.add(panel2D,BorderLayout.CENTER);
		panel.setDoubleBuffered(true);
		
		this.addControlListener(new ControlAdapter() {
			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area =KitchenDraw2D.this.getClientArea();
				 panel.setSize(new Dimension(area.width, area.height));
					panel2D.validate();
					panel2D.repaint();
			}
		});
		
		this.shapeBuilder.addPropertyChangeListener(new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent arg0) {
				panel2D.validate();
				panel2D.repaint();
			}
		});
	}

	@Override
	public void update() {
		super.update();
	}

	@Override
	public boolean setFocus() {
		panel2D.validate();
		panel2D.repaint();
		return super.setFocus();
	}

	@Override
	public void redraw() {
		super.redraw();
		panel2D.validate();
		panel2D.repaint();
	}

	@Override
	public void dispose() {
		super.dispose();
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

}
class Panel2D extends JPanel 
{
	KitchenShapeBuilder creator;

	public Panel2D(KitchenShapeBuilder creator) {
		super();
		setBackground(Color.gray);
		this.creator= creator;

	}




	
	@Override
	public void paint(Graphics g) {
		super.paint(g);
		int areaWidth= (int) this.getSize().getWidth();
		int areaHeight= (int) this.getSize().getHeight();

		Graphics2D g2d  = (Graphics2D)g;
		AffineTransform oldTransform = g2d.getTransform();
		g.setColor(Color.BLACK);
  	
    	BasicStroke strongstrk  = new BasicStroke(7.0f);
    	BasicStroke finestrk  = new BasicStroke(5.0f);

    	if(this.creator!=null) {
    		g2d.setStroke(finestrk);
    		g2d.setColor(Color.BLUE);
    		ArrayList<Polygon> polies = this.creator.createWalls();
    		if(polies.isEmpty())
    			return;
    		ArrayList<Vector2> vertices = new ArrayList<Vector2>();
    		for(Polygon poly: polies) {
    			vertices.addAll(poly.getVertices());
    		}
    		float width = this.creator.getWidth();
    		float height = this.creator.getHeight();
    		
    		Vector2 sizeInMeters = new Vector2(width, height).scl(0.001f);
    		Vector2 drawingArea = new Vector2(areaWidth, areaHeight).sub(40, 40); //using padding of 20px
    		Vector2 ratios = new Vector2(sizeInMeters.x / drawingArea.x, sizeInMeters.y/ drawingArea.y) ;
    		float scale = ratios.x > ratios.y? 1.0f/ratios.x: 1.0f/ratios.y;
    		Vector2 translation = new Vector2(areaWidth, areaHeight).scl(0.5f, 0.5f);
    		for(Polygon poly: polies) {
    			for(int i = 0; i < poly.getVertices().size() - 1; i+=2) {
    				Vector2 v0 = poly.getVertices().get(i).cpy().scl(scale);
    				v0.add(translation);
    				Vector2 v1 = poly.getVertices().get(i + 1).cpy().scl(scale).add(translation);
    	    		g2d.drawLine((int)v0.x, (int)v0.y, (int)v1.x, (int)v1.y);
    			}
    		}
    		
    	}
	}
//	
}
