package dressing.ui.project;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import gdxapp.scenes.SceneEvent;
import geometry.CompoundObject;
import dressing.events.Event;
import dressing.events.EventHandler;
import dressing.handlers.gdx.ToolControlHandler;
import dressing.ui.shapedrawer.FinalPage;

public class CreateFormWizard extends Wizard implements EventHandler {

	private IWizardPage currentPage;
	private FloorConfigWizardFormPage floorPage;
	private MarbreConfigWizardFormPage MarbrePage;
	private WallConfigWizardFormPage wallPage;
	private CreateFormPage formPage;
	private SocleWizardPage soclepage;
	private CompoundObject geometry;
	private CeilingConfigWizardPage ceilingPage;

	public CreateFormWizard(CompoundObject geometry) {
		setWindowTitle("Création d'un objet");
		this.geometry = geometry;
		subscribe(SceneEvent.CREATE_OBJECT_CMD.name());
	}

	public CreateFormPage getFormPage() {
		return formPage;
	}

	@Override
	public void addPages() {
		formPage = new CreateFormPage();
		wallPage = new WallConfigWizardFormPage(geometry.cpy());
		floorPage = new FloorConfigWizardFormPage(geometry.cpy());
		soclepage = new SocleWizardPage(geometry.cpy());
		MarbrePage = new MarbreConfigWizardFormPage("", geometry.cpy());
		ceilingPage = new CeilingConfigWizardPage(geometry.cpy());

		addPage(formPage);
		addPage(wallPage);
		addPage(floorPage);
		addPage(MarbrePage);
		addPage(soclepage);
		addPage(ceilingPage);
		currentPage = getStartingPage();
	}

	@Override
	public boolean performFinish() {
		FinalPage page = (FinalPage) currentPage;
		page.onHide();
		ToolControlHandler.getInstance().triggerSelectObject();
		return true;
	}

	public FloorConfigWizardFormPage getFloorPage() {
		return floorPage;
	}

	public void setFloorPage(FloorConfigWizardFormPage floorPage) {
		this.floorPage = floorPage;
	}

	public WallConfigWizardFormPage getWallPage() {
		return wallPage;
	}

	public MarbreConfigWizardFormPage getMarbrePage() {
		return MarbrePage;
	}

	public void setMarbrePage(MarbreConfigWizardFormPage marbrePage) {
		MarbrePage = marbrePage;
	}

	public void setWallPage(WallConfigWizardFormPage wallPage) {
		this.wallPage = wallPage;
	}

	public SocleWizardPage getSoclepage() {
		return soclepage;
	}

	public void setSoclepage(SocleWizardPage soclepage) {
		this.soclepage = soclepage;
	}

	@Override
	public boolean canFinish() {
		return currentPage != null && currentPage.isPageComplete();
	}

	public void setCurrentPage(IWizardPage page) {
		currentPage = page;
		((FinalPage) currentPage).onDisplay();
		getContainer().updateButtons();
	}

	@Override
	public boolean performCancel() {
		dispose();
		return true;
	}

	@Override
	public void dispose() {
		super.dispose();
		unsubscribe();
	}

	private void createObjectSelected(String type) {
		WizardPage page = null;
		switch (type) {
		case "WALL":
			page = wallPage;
			break;
		case "FLOOR":
			page = floorPage;
			break;
		case "MARBLE":
			page = MarbrePage;
			break;
		case "PLINTH":
			page = soclepage;
			break;
		case "CEILING":
			page = ceilingPage;
			break;
		default:
			throw new IllegalArgumentException("Unexpected value: " + type);
		}
		if (page != null) {
			displayPage(page);
		}

	}

	private void displayPage(WizardPage page) {
		try {
			setCurrentPage(page);
			getContainer().showPage(page);
		} catch (NullPointerException e) {
			e.printStackTrace();
			System.err.println("error");
		}
	}

	@Override
	public void handle(Event event) {
		SceneEvent eventTopic = SceneEvent.valueOf(event.getTopic());
		switch (eventTopic) {
		case CREATE_OBJECT_CMD: {
			createObjectSelected(event.getData().toString());
			break;
		}
		default:
			throw new IllegalArgumentException("Unexpected value: " + eventTopic);
		}
	}

}
