package dressing.ui.parts;


import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.EventObject;

import javax.annotation.PostConstruct;
import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.composite.TreeFormComposite;
import org.eclipse.emf.parsley.composite.TreeFormFactory;
import org.eclipse.emf.parsley.edit.ui.dnd.ViewerDragAndDropHelper;
import org.eclipse.emf.parsley.menus.ViewerContextMenuHelper;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.google.inject.Injector;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import param.MechanicDesign;

public class ParametersPart {
			@Inject
			private ESelectionService selectionService;
	//the EMF Parley composite for showing a tree and a detail form
			private TreeFormComposite treeFormComposite;
			//the EMF Resource
			private Resource resource;
//	
			private Injector injector=null;
			ResourceManagers resourceManager;
			@Inject
			MDirtyable dirty;
			
			@Inject
			IEclipseContext  eclipsecontext;
			
			@Inject
			IEventBroker eventBroker;
			
			@PostConstruct
			public void postConstruct(Composite parent) {
				// Guice injector
				
			
				resourceManager=ResourceManagers.getIntance();
				injector=resourceManager.getInjector();
				EditingDomain editingDomain=resourceManager.getEditingDomain();
				ResourceLoader resourceLoader=resourceManager.getResourceLoader();
				resource=resourceManager.getAppResource();
				TreeFormFactory treeFormFactory = injector.getInstance(TreeFormFactory.class);
//				gereParameters();
				//create the tree-form composite
				treeFormComposite = treeFormFactory.createTreeFormComposite(parent, SWT.BORDER);
			
				// Guice injected viewer context menu helper
				ViewerContextMenuHelper contextMenuHelper = injector.getInstance(ViewerContextMenuHelper.class);
				// Guice injected viewer drag and drop helper
				ViewerDragAndDropHelper dragAndDropHelper = injector.getInstance(ViewerDragAndDropHelper.class);
			
				// set context menu and drag and drop
				contextMenuHelper.addViewerContextMenu(treeFormComposite.getViewer(), editingDomain);
				//contextMenuHelper.addViewerContextMenu(treeFormComposite.getViewer(), editingDomain);
				dragAndDropHelper.addDragAndDrop(treeFormComposite.getViewer(), editingDomain);
			
				treeFormComposite.getViewer().addSelectionChangedListener(new ISelectionChangedListener() {
					
					@Override
					public void selectionChanged(SelectionChangedEvent event) {
						// TODO Auto-generated method stub
						ISelection selection = event.getSelection();
						TreeSelection treeselection = (TreeSelection)selection;
						if(treeselection!=null && 
						   !treeselection.isEmpty() && 
						   treeselection.getFirstElement() instanceof MechanicDesign)
						{

							selectionService.setSelection(treeselection.getFirstElement());

						}

					}
				});
				//update the composite
				treeFormComposite.update(resource);
				

				 
				editingDomain.getCommandStack().addCommandStackListener(
						new CommandStackListener() {
							public void commandStackChanged(EventObject event) {
								if (dirty != null)
									dirty.setDirty(true);
								resourceManager.gereParameters();
							}
						});
				ResourceManagers.getIntance().getApplication().addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if (dirty != null)
						dirty.setDirty(true);
				}
			});
				ResourceManagers.getIntance().getApplication().getLibraries().stream().forEach(lib->lib.addPropertyChangeListener(new PropertyChangeListener() {
					
					@Override
					public void propertyChange(PropertyChangeEvent evt) {
						// TODO Auto-generated method stub
						if (dirty != null)
							dirty.setDirty(true);
					}
				}));
			}
			
			@Persist
			public void save(MDirtyable dirty) throws IOException {
				ResourceManagers.getIntance().saveLibraryResource();
				eventBroker.send("update_DataModel", ModelProvider.getModelroot());
				if (dirty != null) {
					dirty.setDirty(false);
				}
			}
			
}
