package dressing.ui.parts;

import java.net.URL;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.StyledString.Styler;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import dressing.ui.modelprovders.NameLabelProvider;
import dressing.ui.palette.PaletteGroup;
import dressing.ui.palette.PaletteItem;
import dressing.ui.palette.PaletteItemTransferType;
import dressing.ui.palette.PaletteProject;
import dressing.ui.palette.PaletteProvider;
import dressing.ui.palette.PaletteTreeContentProvider;
import dressing.ui.swt.samples.DataTransfer.MyTransfer;
import dressing.ui.swt.samples.DataTransfer.MyType;
import dressing.ui.util.ListenerSelection;

public class PalettePart {

	@Inject 
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;
	
	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;
	static  Display display;
	ListenerSelection listenerSelection;
	public PalettePart() {
	}

	/**
	 * Create contents of the view part.
	 */
	@PostConstruct
	public void createControls(Composite parent) {
		
		display = parent.getDisplay();
		final TreeViewer treeViewer = new TreeViewer(parent, SWT.BORDER|SWT.MULTI);
		final Tree tree = treeViewer.getTree();		

		PaletteProject parentproject = PaletteProvider.PaletteRootInstance();
		treeViewer.setContentProvider(new PaletteTreeContentProvider());
		treeViewer.setInput(parentproject);
		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
		    public void selectionChanged(SelectionChangedEvent event) {
		      IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		      // set the selection to the service
		      Object selectionobj= selection.size() == 1 ? selection.getFirstElement() : selection.toArray();
		      selectionService.setSelection(selectionobj);
		    
		    }
		  });
		 listenerSelection=new ListenerSelection(selectionService);
		
		TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn column = viewerColumn.getColumn();
		column.setText("Nom");
		column.setWidth(200);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new PaletteNameLabelProvider()));
		Listener listener = new Listener() {
		   @Override
		   public void handleEvent(Event event) {
		      TreeItem treeItem = (TreeItem) event.item;
		      
		      final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
		      parent.getDisplay().asyncExec(new Runnable() {
 
		         @Override
		         public void run() {
		            for (TreeColumn treeColumn : treeColumns)
		                 treeColumn.pack();
		         }
		        
		      });
		   }
		};
		tree.addListener(SWT.Expand, listener);
		tree.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		treeViewer.refresh();
				

		int operations = DND.DROP_COPY;
		DragSource source = new DragSource(treeViewer.getControl(), operations);

		Transfer[] types = new Transfer[] {PaletteItemTransferType.getInstance()};
		source.setTransfer(types);
		
//		source.addDragListener(new DragSourceListener() {
//			
//			@Override
//			public void dragStart(DragSourceEvent event) {
//				// TODO Auto-generated method stub
//				event.doit = false;
//				if(event.widget!=null )
//				{
//					DragSource dg = (DragSource)event.widget;
//					//IMPORTANT
//					//il faut seetr le drag source effect a null sinon le label de tree item table sera drawed in canvass3d
//					dg.setDragSourceEffect(null); 
//					Tree treepalete = (Tree) dg.getControl();
//					if(treepalete.getSelectionCount()==1)
//					{
//						if(treepalete.getSelection()[0].getData() instanceof PaletteItem)
//						{
//							event.doit = true;
//						}
//						
//					}
//					
//				}
//				else
//				{
//					int debug=0;
//					debug++;
//				}
//				
//			}
//			
//			@Override
//			public void dragSetData(DragSourceEvent event) {
//				// TODO Auto-generated method stub
//				if(event.widget!=null )
//				{
//					DragSource dg = (DragSource)event.widget;
//					Tree treepalete = (Tree) dg.getControl();
//					if(treepalete.getSelectionCount()==1)
//					{
//						if(treepalete.getSelection()[0].getData() instanceof PaletteItem)
//						{
//							PaletteItem [] pi = new PaletteItem[] { ((PaletteItem) treepalete.getSelection()[0].getData())};
//							event.data = pi;
//						}
//						
//					}
//					
//				}
//			}
//			
//			@Override
//			public void dragFinished(DragSourceEvent event) {
//				// TODO Auto-generated method stub
//				
//			}
//		});
		source.setDragSourceEffect(null);
	    source.addDragListener(new DragSourceAdapter() {
	        public void dragSetData(DragSourceEvent event) {
				if(event.widget!=null )
				{
					DragSource dg = (DragSource)event.widget;
					Tree treepalete = (Tree) dg.getControl();
					if(treepalete.getSelectionCount()==1)
					{
						if(treepalete.getSelection()[0].getData() instanceof PaletteItem)
						{
							PaletteItem [] pi = new PaletteItem[] { ((PaletteItem) treepalete.getSelection()[0].getData())};
							event.data = pi;
						}
						
					}
					
				}
	        }
	      });
	}

	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}
}


class PaletteNameLabelProvider extends LabelProvider implements IStyledLabelProvider {

    @Override
    public StyledString getStyledText(Object element) {
    	if(element!=null && element instanceof PaletteItem)
    	{       
    		   PaletteItem item = (PaletteItem) element;
        		// a directory is just a container and has no size
    			StyledString stytl = new StyledString("");
    			
    			Styler dimstyle = new Styler() {
					
					@Override
					public void applyStyles(TextStyle textStyle) {
						// TODO Auto-generated method stub
						textStyle.foreground = ProjectTreePart.display.getSystemColor(SWT.COLOR_BLUE);
					}
				};
    			stytl.append(item.getName(), dimstyle);
        		return stytl;
    		
    	}
    	else if(element!=null && element instanceof PaletteGroup) {
    		PaletteGroup grp = (PaletteGroup) element;
			StyledString stytl = new StyledString("");
			
			Styler dimstyle = new Styler() {
				
				@Override
				public void applyStyles(TextStyle textStyle) {
					// TODO Auto-generated method stub
					textStyle.foreground = ProjectTreePart.display.getSystemColor(SWT.COLOR_BLUE);
				}
			};
			stytl.append(grp.getName(), dimstyle);
			return stytl;
    	}

        return new StyledString(" ");
    }

	@Override
	public Image getImage(Object element) {
		// TODO Auto-generated method stub
		String s =null;
		if(element instanceof PaletteItem)
		{
			s= ((PaletteItem) element).getImage();
		}
		if(s !=null)
		{
			Bundle bundle = FrameworkUtil.getBundle(NameLabelProvider.class);
			URL url = FileLocator.find(bundle, new Path(s), null);
			ImageDescriptor descriptor = ImageDescriptor.createFromURL(url);
			ResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
			Image im = rsmanager.createImage(descriptor);

			return im;
		}

		return super.getImage(element);
	}

	
}



	
