package dressing.ui.modelprovders;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;

import dressing.cam.model.Usinage;
import dressing.model.DesignObject3D;
import dressing.model.Piece2D;

public class DimLLabelProvider extends LabelProvider implements IStyledLabelProvider {

    @Override
    public StyledString getStyledText(Object element) {
        if (element!=null && element instanceof Piece2D) {
        	Piece2D piece = (Piece2D) element;

        	DecimalFormat formatter = new DecimalFormat("#.0", DecimalFormatSymbols.getInstance( Locale.ENGLISH ));
        	formatter.setRoundingMode( RoundingMode.HALF_UP );
        	String s = formatter.format(piece.getPieceL());
                // a directory is just a container and has no size
                return new StyledString(s);
        }else if(element !=null && element instanceof DesignObject3D && !(element instanceof Usinage)) {
        	DesignObject3D piece = (DesignObject3D) element;

        	DecimalFormat formatter = new DecimalFormat("#.0", DecimalFormatSymbols.getInstance( Locale.ENGLISH ));
        	formatter.setRoundingMode( RoundingMode.HALF_UP );
        	String s = formatter.format(piece.getLongeurext());
                // a directory is just a container and has no size
                return new StyledString(s);
        }
        return new StyledString(" ");
    }
    
}
