package dressing.ui.exemples.tableaux;
import org.eclipse.swt.graphics.Image;


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class Personne implements Comparable<Personne> {
	private String nom;
	private String prenom;
	private int age;

	public int getAge() {
		return age;
	}

	public void setAge(int age) {
		this.age = age;
	}

	public String getBranche() {
		return branche;
	}

	public void setBranche(String branche) {
		this.branche = branche;
	}

	private String branche;

	public String getNom() {
		return nom;
	}

	public void setNom(String nom) {
		this.nom = nom;
	}

	public String getPrenom() {
		return prenom;
	}

	public Personne() {
		super();
		// TODO Auto-generated constructor stub
	}

	public Personne(String nom) {
		super();
		this.nom = nom;
	}

	public void setPrenom(String prenom) {
		this.prenom = prenom;
	}

	public Personne(String nom, String prenom, int age, String branche) {
		super();
		this.nom = nom;
		this.prenom = prenom;
		this.age = age;
		this.branche = branche;
	}

	public void displayPersons() {
		Display display = new Display();
		Shell shell = new Shell(display);
		TableViewer viewer = new TableViewer(shell);

		// Define the columns
		String[] COLUMNS = new String[] { "Nom", "Adresse", "Date de naissance" };
		for (String element : COLUMNS) {
			TableColumn col = new TableColumn(viewer.getTable(), SWT.CENTER);
			col.setText(element);
		}

		// Define the layout of the table
		TableLayout tlayout = new TableLayout();
		tlayout.addColumnData(new ColumnWeightData(40, 100, true));
		tlayout.addColumnData(new ColumnWeightData(40, 150, true));
		tlayout.addColumnData(new ColumnPixelData(100, true));
		viewer.getTable().setLayout(tlayout);

		// The input will be an array or a collection.
		// We will need every element of this input.
		viewer.setContentProvider(new ArrayContentProvider());

		// For very element to display, we will select what to display
		// in function of the column index
		viewer.setLabelProvider(new ITableLabelProvider() {
			SimpleDateFormat formatter = new SimpleDateFormat("dd/mm/yy");

			@Override
			public void removeListener(ILabelProviderListener arg0) {
				// nothing
			}

			@Override
			public boolean isLabelProperty(Object arg0, String arg1) {
				return false;
			}

			@Override
			public void dispose() {
				// nothing
			}

			@Override
			public void addListener(ILabelProviderListener arg0) {
				// nothing
			}

			@Override
			public String getColumnText(Object element, int colmnIndex) {

				String result = null;
				switch (colmnIndex) {
				case 0:
					result = ((Personne) element).getNom();
					break;

				case 1:
					result = ((Personne) element).getPrenom();
					break;

				case 2:
					result = this.formatter.format(((Personne) element).getAge());
					break;
				}

				return result;
			}

			@Override
			public Image getColumnImage(Object element, int colmnIndex) {
				return null;
			}
		});

		// Eventually, let's define an input
		Personne[] persons = new Personne[50];
		for (int i = 0; i <= 50; i++) {
			persons[i] = new Personne("Personne " + i, "Prenom" + i, i, "brache" + i);
		}

		viewer.setInput(persons);
		viewer.refresh();
	}

	public String toString() {
		return "Personne [nom=" + nom + ", prenom=" + prenom + ", age=" + age + ", branche=" + branche + "]";
	}

/**
 * 
 * @param personnes
 * @param flag
 * method to sort a list of perssones by the first name with the ability to shose the way to sort the list even descended or ascended
 */
	public static void sortByName(List<Personne> personnes,Boolean flag) {
		if (flag==true) {
			Collections.sort(personnes, perNameComparatorASC);
		}else
		{
			Collections.sort(personnes, perNameComparatorDESC);
		}
		
	}
	/**
	 * 
	 * @param personnes
	 * @param flag
	 * method to sort a list of perssones by the last name with the ability to shose the way to sort the list even descended or ascended
	 */
	public static void sortByLastName(List<Personne> personnes, int flag) {
		if (flag==0) {
			Collections.sort(personnes, perLastNameComparatorASC);
		}else
		{
			Collections.sort(personnes, perLastNameComparatorDESC);
		}
	}
	public static Comparator<Personne> perNameComparatorASC = new Comparator<Personne>() {
		@Override
		public int compare(Personne s1, Personne s2) {
			String PersonName1 = s1.getNom().toUpperCase();
			String PersonName2 = s2.getNom().toUpperCase();

			// ascending order
			return PersonName1.compareTo(PersonName2);

			// descending order
			// return PersonName2.compareTo(PersonName1);
		}

	};
	public static Comparator<Personne> perNameComparatorDESC = new Comparator<Personne>() {
		@Override
		public int compare(Personne s1, Personne s2) {
			String PersonName1 = s1.getNom().toUpperCase();
			String PersonName2 = s2.getNom().toUpperCase();

			// ascending order
//			return PersonName1.compareTo(PersonName2);

			// descending order
			 return PersonName2.compareTo(PersonName1);
		}

	};
	public static Comparator<Personne> perLastNameComparatorASC = new Comparator<Personne>() {
		@Override
		public int compare(Personne s1, Personne s2) {
			String PersonLastName1 = s1.getPrenom().toUpperCase();
			String PersonLastName2 = s2.getPrenom().toUpperCase();

			// ascending order
			return PersonLastName1.compareTo(PersonLastName2);

			// descending order
//			 return PersonName2.compareTo(PersonName1);
		}

	};
	public static Comparator<Personne> perLastNameComparatorDESC = new Comparator<Personne>() {
		@Override
		public int compare(Personne s1, Personne s2) {
			String PersonLastName1 = s1.getPrenom().toUpperCase();
			String PersonLastName2 = s2.getPrenom().toUpperCase();

			// ascending order
//			return PersonLastName1.compareTo(PersonLastName2);

			// descending order
			 return PersonLastName2.compareTo(PersonLastName1);
		}

	};
	

	@Override
	public int compareTo(Personne o) {
		int last = this.nom.compareTo(o.nom);
		// Sorting by first name if last name is same d
		return last == 0 ? this.prenom.compareTo(o.prenom) : last;
	}

}
