package dressing.ui.exemples.tableaux;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Item;

public class ClientCellModifier implements ICellModifier {
	private Viewer viewer;

	public ClientCellModifier(Viewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * Returns whether the property can be modified
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean canModify(Object element, String property) {
		// Allow editing of all values
		return true;
	}

	/**
	 * Returns the value for the property
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return Object
	 */
	public Object getValue(Object element, String property) {
		Client c = (Client) element;
		if (ClientEditor.NAME.equals(property))
			return c.getNom();
		else if (ClientEditor.AGE.equals(property))
			return (c.getAge().toString());

		else
			return null;
	}

	/**
	 * Modifies the element
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @param value
	 *            the value
	 */
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Client c = (Client) element;
		if (ClientEditor.NAME.equals(property))
			c.setNom((String) value);
		else if (ClientEditor.AGE.equals(property))
		{
//			try {
				c.setAge(Integer.parseInt((String) value));
//			}catch(NumberFormatException e)
//			{
//				System.out.println("Le nombre entrer est incorrect");
//			}
		}
			
		// Force the viewer to refresh
		
		viewer.refresh();
		for (Client c1:ClientEditor.clients) {
			System.out.println(c1.toString()+" ");
		}
	}
}
