package dressing.ui.engine3d.sceneconfig;

import org.eclipse.jface.wizard.Wizard;

import dressing.config.UserPreference;
import dressing.model.ProjectManager;
import dressing.ui.project.HandleConfigWizardPage;
import gdxapp.scenes.Scene;
import gdxapp.scenes.ScenePreferences;

public class SceneConfigWizard extends Wizard {


	HandleConfigWizardPage wizardPage;
	ScenePreferences preferences;
	
	
	public SceneConfigWizard() {
		setWindowTitle("Préference de scéne");
		preferences = ProjectManager.getManager().getCurrentScene().getPreferences();
	}
	
	


	@Override
	public void addPages() {
		this.wizardPage = new HandleConfigWizardPage("", ProjectManager.getManager().getCurrentScene().getPreferences());
		wizardPage.setPreferences(preferences);
		this.addPage(wizardPage);
	}




	@Override
	public boolean performFinish() {
		//refresh code
		 ProjectManager.instance.getCurrentScene().requireRefresh = true;
		 UserPreference.getPreference().save();
		return true;
	}

}
