package dressing.ui.editorWindows;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.ModulesPreferences;
import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.ImageLoaderCache;
import param.Accessoire;
import param.AccessoireInstance;
import param.Article;
import param.ArticleFamily;
import param.ArticleFamilyGroup;
import param.ArticleInstance;
import param.BaseObject;
import param.Quincaillerie;
import param.QuincaillerieInstance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import dressing.ui.DoubleTextFieldFactory;

public class ArticleInstanceEditorWindow extends EditorWindow {
	boolean isShowCost= ModulesPreferences.getInstance().getBoolean("ui.showCost", true);
	boolean isShowSalePrice= ModulesPreferences.getInstance().getBoolean("ui.showSalePrice", true);

	private DataBindingContext m_bindingContext;

	private ScrolledComposite container;
	private Composite root;

	private Text txtName;
	private Text txtNumber;
	private Text txtPrice;
	private Text txtSalePrice;

	private ArticleInstance articleInstance;
	private ArticleInstance articleInstanceOrigin;

	private Composite composite;

	private ComboViewer comboViewerArticle;
	private Label lblImage;
	private Button btnModifiable;
	private Button btnStandAlone;
	private Label lblFamilleArticle;
	private Combo comboFamilleArticle;
	private ComboViewer comboViewerFamilleArticle;
	private Button btnAfficherDevis;
	public ArticleInstanceEditorWindow(Shell parentShell,int update,ArticleInstance article) {
		super(parentShell,update);
		this.articleInstance = article;
		this.articleInstanceOrigin=EcoreUtil.copy(article);// deep copy as origin snapshot
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		
		container = new ScrolledComposite(parent, SWT.V_SCROLL);
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		container.setExpandHorizontal(true);
		container.setExpandVertical(true);
		
		root = new Composite(container, SWT.NONE);
		root.setLayout(new GridLayout(3, false));
		
		composite = new Composite(root, SWT.NONE);
		composite.setLayout(new FillLayout(SWT.HORIZONTAL));
		GridData gd_composite = new GridData(SWT.LEFT, SWT.FILL, false, true, 1, 9);
		gd_composite.heightHint = 400;
		gd_composite.minimumWidth = 200;
		gd_composite.minimumHeight = 200;
		gd_composite.widthHint = 400;
		composite.setLayoutData(gd_composite);
		
		lblImage = new Label(composite, SWT.NONE);
		
		lblFamilleArticle = new Label(root, SWT.NONE);
		lblFamilleArticle.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblFamilleArticle.setText("Famille Article");
		
		comboViewerFamilleArticle = new ComboViewer(root, SWT.READ_ONLY);
		comboFamilleArticle = comboViewerFamilleArticle.getCombo();
		comboFamilleArticle.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
		
		Label lblArticle = new Label(root, SWT.NONE);
		lblArticle.setText("Article");
		
		comboViewerArticle = new ComboViewer(root, SWT.READ_ONLY);
		Combo comboArticle = comboViewerArticle.getCombo();
		comboArticle.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));

		
		Label lblNom = new Label(root, SWT.NONE);
		lblNom.setText("Nom");
		
		txtName = new Text(root, SWT.BORDER);
//		txtName.setEditable(false);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblNumber = new Label(root, SWT.NONE);
		lblNumber.setText("Nombre");
		
		txtNumber =DoubleTextFieldFactory.createDoubleTextField(root, SWT.BORDER);
		txtNumber.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		if(isShowCost) {
			Label lblPrice = new Label(root, SWT.NONE);
			lblPrice.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
			lblPrice.setText("Prix");
			
			txtPrice = DoubleTextFieldFactory.createDoubleTextField(root, SWT.BORDER);
			txtPrice.setEditable(false);
			txtPrice.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
			txtPrice.setToolTipText("Le prix est calculable suivant l'article séléctionner et le nombre");
		}
		if(isShowSalePrice) {
			Label lblSalePrice = new Label(root, SWT.NONE);
			lblSalePrice.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false, 1, 1));
			lblSalePrice.setText("Prix de Vente");
			
			txtSalePrice = DoubleTextFieldFactory.createDoubleTextField(root, SWT.BORDER);
			txtSalePrice.setEditable(false);
			txtSalePrice.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
			txtSalePrice.setToolTipText("Le prix est calculable suivant l'article séléctionner et le nombre");
		}
		
		btnModifiable = new Button(root, SWT.CHECK);
		btnModifiable.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 2, 1));
		btnModifiable.setText("Modifiable");
		
		btnStandAlone = new Button(root, SWT.CHECK);
		btnStandAlone.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 2, 1));
		btnStandAlone.setText("Calcule Séparer");
		
		btnAfficherDevis = new Button(root, SWT.CHECK);
		btnAfficherDevis.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 2, 1));
		btnAfficherDevis.setText("Afficher Devis");

		container.setContent(root);
		container.setMinSize(root.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		
		String titleWindow = "d'Accessoire";
		if(this.articleInstance instanceof AccessoireInstance) {
			titleWindow="Accessoire";
		}
		if(this.articleInstance instanceof QuincaillerieInstance) {
			titleWindow="du Quincaillerie";
		}
		this.shell.setText("Editeur " + titleWindow);

		addControl();
		m_bindingContext = initspecialDataBindings();
		if(getUpdateMode()==EditorWindow.update || getUpdateMode()==EditorWindow.View) {
			Article article=null;
			if(this.articleInstance instanceof AccessoireInstance) {
				article=((AccessoireInstance) this.articleInstance).getAccessoire();
			}
			if(this.articleInstance instanceof QuincaillerieInstance) {
				article=((QuincaillerieInstance) this.articleInstance).getQuincaillerie();
			}
			if(article!=null)
			{
				comboViewerArticle.setSelection(new StructuredSelection(article));
				updateImage(article);
				updatePrice(article);
			}
			
		}
		
		return container;
	}
	public void addControl() {
		comboViewerArticle.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof Article) {
					Article article = (Article) element;
					return article.getName();
				}
				return super.getText(element);
			}
		});
		
		comboViewerArticle.setContentProvider(new ArticleInstanceContentProvider(articleInstance instanceof AccessoireInstance));

		// populate articles depending on fixed family or groups
		if (articleInstance.getFixedFamily() != null) {
		comboViewerArticle.setInput(articleInstance.getFixedFamily());
		} else if (articleInstance instanceof AccessoireInstance) {
		comboViewerArticle.setInput(ResourceManagers.getIntance().getAccessoireGroup().getAccessoires());
		} else {
		comboViewerArticle.setInput(ResourceManagers.getIntance().getQuincailleriesGroup().getQuincailleries());
		}
		
		comboViewerArticle.addSelectionChangedListener(new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection=comboViewerArticle.getStructuredSelection().getFirstElement();
				if(selection !=null) {
					if(selection instanceof Article) {
						Article acc=(Article)selection;
						if(acc!=null)
						{
							// only update name if empty
							if (txtName.getText().trim().isEmpty()) {
								txtName.setText(acc.getName());
							}
							updateImage(acc);
							updatePrice(acc);
						}
						
					}
				}
				
			}
		});
		txtNumber.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				refreshPrice();
			}
		});

		comboViewerFamilleArticle.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				if (element instanceof ArticleFamily) {
					ArticleFamily family = (ArticleFamily) element;
					String name = family.getName();
					ArticleFamily parent = family.getParentFamily();
					while (parent != null) {
						name = parent.getName() + "\\" + name;
						parent = parent.getParentFamily();
					}
					return name;
				}
				return "";
			}
		});
		
		if(!articleInstance.isStatic()) {
			txtNumber.setEditable(false);
			txtNumber.setToolTipText("Il est interdit de modifier la quantité d'un article dont le nombre est calculable");
		}
		
		comboViewerFamilleArticle.setContentProvider(new IStructuredContentProvider() {
			
			@Override
			public Object[] getElements(Object inputElement) {
				List<Object> families = new ArrayList<Object>();
				families.add(SetCommand.UNSET_VALUE);
				if (inputElement instanceof ArticleFamilyGroup) {
					ArticleFamilyGroup familyGroup = (ArticleFamilyGroup) inputElement;
					for (ArticleFamily family : familyGroup.getFamilles()) {
						families.add(family);
						getfamilies(family, families);
					}
				}
				return families.toArray();
			}

			private void getfamilies(ArticleFamily family,List<Object> families) {
				for(ArticleFamily subfamily:family.getFamilies()) {
					families.add(subfamily);
					getfamilies(subfamily,families);
				}
			}
		});
		comboViewerFamilleArticle.setInput(ResourceManagers.getIntance().getApplication().getArticleFamilies());
		comboViewerFamilleArticle.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection = comboViewerFamilleArticle.getStructuredSelection().getFirstElement();
				if (selection instanceof ArticleFamily) {
					// try to keep previous selection if it belongs to that family
					Object current = comboViewerArticle.getStructuredSelection().getFirstElement();
					comboViewerArticle.setInput((ArticleFamily) selection);
					if (current instanceof Article) {
						comboViewerArticle.setSelection(new StructuredSelection(current));
					}
				}
			}
		});
		
		lblImage.addDisposeListener(e -> {
			Image img = lblImage.getImage();
			if (img != null && !img.isDisposed()) {
				img.dispose();
			}
		});	
	}
	private void refreshPrice() {
		Object selection = comboViewerArticle.getStructuredSelection().getFirstElement();
		if (selection instanceof Article) {
			updatePrice((Article) selection);
		} else {
			// clear
			if (txtPrice != null && !txtPrice.isDisposed()) {
				txtPrice.setText("0.0");
			}
			if (txtSalePrice != null && !txtSalePrice.isDisposed()) {
				txtSalePrice.setText("0.0");
			}
		}
	}

	private double parseQuantity() {
		if (txtNumber == null || txtNumber.isDisposed())
			return articleInstance.getNombreFix();
		try {
			String s = txtNumber.getText();
			if (s == null || s.trim().isEmpty())
				return articleInstance.getNombreFix();
			return Double.parseDouble(s);
		} catch (Exception e) {
			return articleInstance.getNombreFix();
		}
	}

	private void updatePrice(Article article) {
		double qty = parseQuantity();
		if (txtPrice != null && !txtPrice.isDisposed()) {
			String price = String.valueOf(article.getPrix() * qty);
			txtPrice.setText(price);
		}
		if (txtSalePrice != null && !txtSalePrice.isDisposed()) {
			String salePrice = String.valueOf(article.getSalePrice() * qty);
			txtSalePrice.setText(salePrice);
		}
	}
	
	@Override
	public void finish() {
		Image img = lblImage.getImage();
		if (img != null && !img.isDisposed()) {
			img.dispose();
		}
		super.finish();
	}
	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		
		Object obj = comboViewerArticle.getStructuredSelection().getFirstElement();
		if(articleInstance instanceof AccessoireInstance && obj instanceof Accessoire) {
		    ((AccessoireInstance)articleInstance).setAccessoire((Accessoire)obj);
		}
		if(articleInstance instanceof QuincaillerieInstance && obj instanceof Quincaillerie) {
		    ((QuincaillerieInstance)articleInstance).setQuincaillerie((Quincaillerie)obj);
		}

		Object selection=comboViewerFamilleArticle.getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof ArticleFamily) {
			this.articleInstance.setFixedFamily((ArticleFamily) selection);
		}
		
		finish();
		return true;
	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		String numberS=txtNumber.getText();
		try {
			Double numberD =Double.valueOf(numberS);
			if(numberD<=0) {
				errorExist=true;
				errorMessage="Le nombre doit être supérieur à 0";
			}
		} catch (Exception e) {
			errorExist=true;
			errorMessage="Le nombre est obligatoire";
		}
		Object article = comboViewerArticle.getStructuredSelection().getFirstElement();
		if(article==null || !(article instanceof Article)){
			errorExist=true;
			errorMessage="L'Article est obligatoire";
		}
		return !errorExist;
	}
	public ScrolledComposite getContainer() {
		return container;
	}

	public void setContainer(ScrolledComposite container) {
		this.container = container;
	}

	public Composite getRoot() {
		return root;
	}

	public void setRoot(Composite root) {
		this.root = root;
	}
	
	@Override
	protected void cancel() {
		// restore important fields from origin snapshot
		if (articleInstanceOrigin != null) {
			try {
				// restore simple fields
				this.articleInstance.setName(articleInstanceOrigin.getName());
				this.articleInstance.setNombreFix(articleInstanceOrigin.getNombreFix());
				this.articleInstance.setFixedFamily(articleInstanceOrigin.getFixedFamily());
				this.articleInstance.setChangeable(articleInstanceOrigin.isChangeable());
				this.articleInstance.setStandAlone(articleInstanceOrigin.isStandAlone());
				this.articleInstance.setShowReport(articleInstanceOrigin.isShowReport());
				// restore article link depending on concrete subclass
				if (this.articleInstance instanceof AccessoireInstance
						&& articleInstanceOrigin instanceof AccessoireInstance) {
					((AccessoireInstance) this.articleInstance)
							.setAccessoire(((AccessoireInstance) articleInstanceOrigin).getAccessoire());
				}
				if (this.articleInstance instanceof QuincaillerieInstance
						&& articleInstanceOrigin instanceof QuincaillerieInstance) {
					((QuincaillerieInstance) this.articleInstance)
							.setQuincaillerie(((QuincaillerieInstance) articleInstanceOrigin).getQuincaillerie());
				}
			} catch (Exception e) {
				// fallback: deep copy replacement
				try {
					EcoreUtil.copy(articleInstanceOrigin).eDeliver();
				} catch (Exception ex) {
					// ignore - best effort restore
				}
			}
		}
	}
	
	protected DataBindingContext initspecialDataBindings() {
		DataBindingContext bindingContext = initDataBindings();

		//
		IObservableValue observeSelectionBtnModifiableObserveWidget = WidgetProperties.buttonSelection().observe(btnModifiable);
		IObservableValue changeableArticleInstanceObserveValue = BeanProperties.value("changeable").observe(articleInstance);
		bindingContext.bindValue(observeSelectionBtnModifiableObserveWidget, changeableArticleInstanceObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnStandAloneObserveWidget = WidgetProperties.buttonSelection().observe(btnStandAlone);
		IObservableValue standAloneArticleInstanceObserveValue = BeanProperties.value("standAlone").observe(articleInstance);
		bindingContext.bindValue(observeSelectionBtnStandAloneObserveWidget, standAloneArticleInstanceObserveValue, null, null);
		//
		IObservableValue observeSelectionbtnbtnAfficherDevisObserveWidget = WidgetProperties.buttonSelection().observe(btnAfficherDevis);
		IObservableValue showReportArticleInstanceObserveValue = BeanProperties.value("showReport").observe(articleInstance);
		bindingContext.bindValue(observeSelectionbtnbtnAfficherDevisObserveWidget, showReportArticleInstanceObserveValue, null, null);
		//

		return bindingContext;
	}
	@Override
	protected Point getInitialSize() {
		
		return new Point(1200, 600);
	}
	@Override
	protected boolean isMaximized() {
		
		return false;
	}

	public void updateImage(Article article) {
		if (lblImage == null || lblImage.isDisposed())
			return;
		Image old = lblImage.getImage();
		if (old != null && !old.isDisposed()) {
			old.dispose();
		}
		if (article == null || article.getImage() == null || article.getImage().getPath() == null
				|| article.getImage().getPath().isEmpty()) {
			lblImage.setImage(null);
			return;
		}
		
		Image img = ImageLoaderCache.getInstance().loadImage(article.getImage().getPath(), 400, 400, false);
		if (img != null && !img.isDisposed()) {
			lblImage.setImage(img);
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameAccessoireObserveValue = BeanProperties.value("name").observe(articleInstance);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameAccessoireObserveValue, null, null);
		//
		IObservableValue observeTextTxtNumberObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtNumber);
		IObservableValue nombreFixArticleObserveValue = BeanProperties.value("nombreFix").observe(articleInstance);
		bindingContext.bindValue(observeTextTxtNumberObserveWidget, nombreFixArticleObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerFamilleArticle = ViewerProperties.singleSelection().observe(comboViewerFamilleArticle);
		IObservableValue fixedFamilyArticleInstanceObserveValue = BeanProperties.value("fixedFamily").observe(articleInstance);
		bindingContext.bindValue(observeSingleSelectionComboViewerFamilleArticle, fixedFamilyArticleInstanceObserveValue, null, null);
		//
		return bindingContext;
	}
}
class ArticleInstanceContentProvider implements IStructuredContentProvider {

	private boolean isAccessoire=true;
	public ArticleInstanceContentProvider(boolean isAccessoire) {
		this.isAccessoire=isAccessoire;
	}
	
	/**
	 * Returns the elements in the input, which must be either an array or a
	 * <code>Collection</code>.
	 */
	@Override
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof Object[]) {
			return (Object[]) inputElement;
		}
		if (inputElement instanceof Collection) {
			return ((Collection<?>) inputElement).toArray();
		}
		ArrayList<BaseObject> articles = new ArrayList<BaseObject>();
		Set<BaseObject> seen = new HashSet<BaseObject>();

		if (inputElement instanceof ArticleFamily) {
			collectArticles((ArticleFamily) inputElement, articles, seen);
			return articles.toArray();
		}
		if (inputElement instanceof ArticleFamilyGroup) {
			ArticleFamilyGroup group = (ArticleFamilyGroup) inputElement;
			if (group.getFamilles() != null) {
				for (ArticleFamily sub_family : group.getFamilles()) {
					collectArticles(sub_family, articles, seen);
				}
			}
			return articles.toArray();
		}
		return new Object[0];
	}

	private void collectArticles(ArticleFamily family, List<BaseObject> articles, Set<BaseObject> seen) {
		if (family == null)
			return;
		if (isAccessoire && family.getAccessoires() != null) {
			for (BaseObject obj : family.getAccessoires()) {
				if (!seen.contains(obj)) {
					seen.add(obj);
					articles.add(obj);
				}
			}
		}
		if (!isAccessoire && family.getQuincailleries() != null) {
			for (BaseObject obj : family.getQuincailleries()) {
				if (!seen.contains(obj)) {
					seen.add(obj);
					articles.add(obj);
				}
			}
		}
		if (family.getFamilies() != null) {
			for (ArticleFamily sub : family.getFamilies()) {
				collectArticles(sub, articles, seen);
			}
		}
	}
}