package dressing.ui;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.cam.model.Trou;

import org.eclipse.swt.SWT;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;

public class TrouPropertiesComposite extends Composite {
	private DataBindingContext m_bindingContext;

	private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
	private Trou trou=null;
	private Label nom;
	private Label profondeur;
	private Label diametere;
	private Label direction;
	private Label xpos;
	private Label ypos;
	private Label zpos;
	
	public TrouPropertiesComposite(Composite parent, int style, Trou newDesignObject3D) {
		this(parent, style);
		setTrou(newDesignObject3D);
		if(trou!=null) {
			m_bindingContext = initDataBindings();
		}
	}
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */
	public TrouPropertiesComposite(Composite parent, int style) {
		super(parent, style);
		setBackground(SWTResourceManager.getColor(SWT.COLOR_GREEN));
		addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent e) {
				toolkit.dispose();
			}
		});
		toolkit.adapt(this);
		toolkit.paintBordersFor(this);
		setLayout(new GridLayout(1, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setFont(SWTResourceManager.getFont("Segoe UI", 9, SWT.NORMAL));
		composite.setBackground(SWTResourceManager.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		composite.setLayout(new GridLayout(2, false));
		GridData gd_composite = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_composite.heightHint = 211;
		gd_composite.widthHint = 336;
		composite.setLayoutData(gd_composite);
		toolkit.adapt(composite);
		toolkit.paintBordersFor(composite);
		
		Label lblNewLabel = new Label(composite, SWT.NONE);
		lblNewLabel.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(lblNewLabel, true, true);
		lblNewLabel.setText("Nom");
		
		nom = new Label(composite, SWT.NONE);
		nom.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		nom.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(nom, true, true);
		
		Label lblNewLabel_1 = new Label(composite, SWT.NONE);
		lblNewLabel_1.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(lblNewLabel_1, true, true);
		lblNewLabel_1.setText("profondeur");
		
		profondeur = new Label(composite, SWT.NONE);
		profondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		profondeur.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(profondeur, true, true);
		
		Label lblNewLabel_2 = new Label(composite, SWT.NONE);
		lblNewLabel_2.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(lblNewLabel_2, true, true);
		lblNewLabel_2.setText("diamètre");
		
		diametere = new Label(composite, SWT.NONE);
		diametere.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		diametere.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(diametere, true, true);
		
		Label lblNewLabel_3 = new Label(composite, SWT.NONE);
		lblNewLabel_3.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(lblNewLabel_3, true, true);
		lblNewLabel_3.setText("direction");
		
		direction = new Label(composite, SWT.NONE);
		direction.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		direction.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(direction, true, true);
		
		Label lblNewLabel_4 = new Label(composite, SWT.NONE);
		lblNewLabel_4.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(lblNewLabel_4, true, true);
		lblNewLabel_4.setText("Xpos");
		
		xpos = new Label(composite, SWT.NONE);
		xpos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		xpos.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(xpos, true, true);
		
		Label lblYpos = new Label(composite, SWT.NONE);
		lblYpos.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(lblYpos, true, true);
		lblYpos.setText("Ypos");
		
		ypos = new Label(composite, SWT.NONE);
		ypos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		ypos.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(ypos, true, true);
		
		Label lblZpos = new Label(composite, SWT.NONE);
		lblZpos.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(lblZpos, true, true);
		lblZpos.setText("Zpos");
		
		zpos = new Label(composite, SWT.NONE);
		zpos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		zpos.setBackground(SWTResourceManager.getColor(SWT.COLOR_GREEN));
		zpos.setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		toolkit.adapt(zpos, true, true);
		if(trou!=null) {
			m_bindingContext = initDataBindings();
		}
		

	}
	public Trou getTrou() {
		return trou;
	}
	public void setTrou(Trou trou) {
		setTrou(trou,true);
	}

	public void setTrou(Trou trou, boolean update) {
		this.trou = trou;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (this.trou != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextNomObserveWidget = WidgetProperties.text().observe(nom);
		IObservableValue nameTrouObserveValue = BeanProperties.value("name").observe(trou);
		bindingContext.bindValue(observeTextNomObserveWidget, nameTrouObserveValue, null, null);
		//
		IObservableValue observeTextProfondeurObserveWidget = WidgetProperties.text().observe(profondeur);
		IObservableValue depthTrouObserveValue = BeanProperties.value("depth").observe(trou);
		bindingContext.bindValue(observeTextProfondeurObserveWidget, depthTrouObserveValue, null, null);
		//
		IObservableValue observeTextDiametereObserveWidget = WidgetProperties.text().observe(diametere);
		IObservableValue diameterTrouObserveValue = BeanProperties.value("diameter").observe(trou);
		bindingContext.bindValue(observeTextDiametereObserveWidget, diameterTrouObserveValue, null, null);
		//
		IObservableValue observeTextDirectionObserveWidget = WidgetProperties.text().observe(direction);
		IObservableValue directionTrouObserveValue = BeanProperties.value("direction").observe(trou);
		bindingContext.bindValue(observeTextDirectionObserveWidget, directionTrouObserveValue, null, null);
		//
		IObservableValue observeTextXposObserveWidget = WidgetProperties.text().observe(xpos);
		IObservableValue xcenterTrouObserveValue = BeanProperties.value("xcenter").observe(trou);
		bindingContext.bindValue(observeTextXposObserveWidget, xcenterTrouObserveValue, null, null);
		//
		IObservableValue observeTextYposObserveWidget = WidgetProperties.text().observe(ypos);
		IObservableValue ycenterTrouObserveValue = BeanProperties.value("ycenter").observe(trou);
		bindingContext.bindValue(observeTextYposObserveWidget, ycenterTrouObserveValue, null, null);
		//
		IObservableValue observeTextZposObserveWidget = WidgetProperties.text().observe(zpos);
		IObservableValue zcenterTrouObserveValue = BeanProperties.value("zcenter").observe(trou);
		bindingContext.bindValue(observeTextZposObserveWidget, zcenterTrouObserveValue, null, null);
		//
		return bindingContext;
	}
}
