package dressing.ui;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import dressing.config.WorkspaceConfiguration;

public class TexturesComposite extends Composite {
	@Inject 
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;
	
	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;
	
	public static final String NAME = "Name";
	public List<Model> listimage = new ArrayList<Model>();
	public static final String[] PROPS = {NAME};
	private Table table;
	private TableViewer tableViewer;
	PropertyChangeListener pcl;
	private boolean addMenu=true;
	/**
	 * Create the composite.
	 * @param parent
	 * @param handlerService2 
	 * @param commandService2 
	 * @param style
	 */
	public TexturesComposite(Composite parent, ECommandService commandService, EHandlerService handlerService, int style) {
		this(parent, commandService, handlerService, style, true);
	}
	public TexturesComposite(Composite parent, ECommandService commandService, EHandlerService handlerService, int style,boolean addMenu) {
		super(parent, style);
		this.commandService=commandService;
		this.handlerService=handlerService;
		this.addMenu=addMenu;
		initModel();
		initTable();
		
	}
	private void initModel() {
		this.listimage.clear();
		File pictures = new File(WorkspaceConfiguration.getDefaultConfDir() + "/pictures");
		File[] files = pictures.listFiles();
		for (File file : files) {
			addElement(file);			
		}
	}
	public void addElement(File file ) {
		Model model=new Model(file.getPath(), file.getName());
		//imed bug 1460 
		ImageData id = new ImageData(file.getPath());
		@SuppressWarnings("deprecation")
		ImageDescriptor descriptor = ImageDescriptor.createFromImageData(id);
		LocalResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
		Image im = rsmanager.createImage(descriptor);
		Image scaled216 = new Image(null, im.getImageData().scaledTo(64, 32));
		model.setImage(scaled216);
		this.listimage.add(model);
	}
	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	public String getSelection() {
		Model selection=((Model) tableViewer.getStructuredSelection().getFirstElement());
		return selection!=null?selection.getName():"";
	}
	public void setSelection(String value) {
		for(Model model :listimage) {
			if(model.getName().contentEquals(value)) {
				tableViewer.setSelection(new StructuredSelection(model));
			}
		}
		
	}
	private void initTable()
	{
		setLayout(new GridLayout(1, false));
		tableViewer = new TableViewer(this, SWT.BORDER | SWT.FULL_SELECTION|SWT.FILL|SWT.V_SCROLL);
		tableViewer.setContentProvider(new TexturesContentProvider());
		tableViewer.setLabelProvider(new TexturesLabelProvider(tableViewer));
		tableViewer.setInput(this.listimage);

		table = tableViewer.getTable();
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_table.widthHint = 590;
		table.setLayoutData(gd_table);

		TableColumn tblClmn=  new TableColumn(table, SWT.LEFT);
	    tblClmn.setText(NAME);
	    tblClmn.setWidth(126);
	  
		for (int i = 0, n = table.getColumnCount(); i < n; i++) {
			table.getColumn(i).pack();
		}
		for (int i = 0, n = table.getItemCount(); i < n; i++) {
			table.getItem(i).setGrayed(false);
		}
		ControlAdapter cal= new ControlAdapter() {
		
		    public void controlResized(ControlEvent e) {
		    	
		      Rectangle area = TexturesComposite.this.getClientArea();
		      Point preferredSize = table.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		      int width = area.width - 2*table.getBorderWidth();
		      if (preferredSize.y > area.height + table.getHeaderHeight()) {
		        // Subtract the scrollbar width from the total column width
		        // if a vertical scrollbar will be required
		        Point vBarSize = table.getVerticalBar().getSize();
		        width -= vBarSize.x;
		      }
		      Point oldSize = table.getSize();
		      if (oldSize.x > area.width) {
		        // table is getting smaller so make the columns 
		        // smaller first and then resize the table to
		        // match the client area width
		        tblClmn.setWidth(width-2*table.getBorderWidth());		  
		    
		        table.setSize(area.width, area.height);
		      } else {
		        // table is getting bigger so make the table 
		        // bigger first and then make the columns wider
		        // to match the client area width
		        table.setSize(area.width, area.height);
		        tblClmn.setWidth(width-2*table.getBorderWidth());
		       		       
		      }
		    }};
		
		  
		this.addControlListener(cal);
		table.addControlListener(cal);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		tableViewer.refresh();

		CellEditor[] editors = new CellEditor[4];
		editors[0] = new TextCellEditor(table);
		editors[0].getControl().setEnabled(false);
		editors[0].getControl().setVisible(false);


		tableViewer.setColumnProperties(PROPS);
		tableViewer.setCellModifier(new TexturesCellModifier(tableViewer));
		tableViewer.setCellEditors(editors);
//		//
//		
//		tableViewer.addSelectionChangedListener(new ISelectionChangedListener() {
//		    public void selectionChanged(SelectionChangedEvent event) {
//		      IStructuredSelection selection = (IStructuredSelection) event.getSelection();
//		      // set the selection to the service
//		      Object selectionobj= selection.size() == 1 ? selection.getFirstElement() : selection.toArray();
//		      selectionService.setSelection(selectionobj);
//		    
//		    }
//		  });
//		//
		if(this.addMenu) {
			MenuManager menuMgr = new MenuManager();

	        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
	        menuMgr.addMenuListener(new IMenuListener() {
				
				@Override
				public void menuAboutToShow(IMenuManager manager) {
					// TODO Auto-generated method stub
					manager.add(new Action("Copier") {
	                	public void run() {
	        					String textData = ((Model) tableViewer.getStructuredSelection().getFirstElement()).getName();
	        					Clipboard clipboard = new Clipboard(Display.getCurrent());
	        		    	    TextTransfer textTransfer = TextTransfer.getInstance();
	        		    	    Transfer[] transfers = new Transfer[]{textTransfer};
	        		    	    Object[] data = new Object[]{textData};
	        		    	    clipboard.setContents(data, transfers);
	        		    	    clipboard.dispose();
	                	};
					});
					manager.add(new Action("Ajouter texture") {
	                	public void run() {
	                		ParameterizedCommand cmd = commandService.createCommand("dressing.command.addtexture", null);                        	
	                		handlerService.executeHandler(cmd);
	                	};
					});
				}
			});
	        menuMgr.setRemoveAllWhenShown(true);
	        tableViewer.getControl().setMenu(menu);
		}
		
	
	}
	
	private ColumnLabelProvider createLabelProviderFor(final TableViewer viewer) {
		return new ColumnLabelProvider() {
			boolean isEvenIdx = true;

			@Override
			public void update(ViewerCell cell) {
				super.update(cell);
			}
		};
	}
	private TableViewerColumn createColumnFor(TableViewer viewer, String label) {
		TableViewerColumn column;
		column = new TableViewerColumn(viewer, SWT.NONE);
		column.getColumn().setWidth(200);
		column.getColumn().setText(label);
		column.setLabelProvider(createLabelProviderFor(viewer));
		return column;
	}

	public void refresh() {
		if(this.tableViewer!=null) {
			this.tableViewer.refresh();
		}
	}
}
class TexturesContentProvider implements IStructuredContentProvider {
	/**
	 * Returns the Person objects
	 */
	public Object[] getElements(Object inputElement) {
		return ((List) inputElement).toArray();
	}
}

/**
 * This class provides the content for the FoodList application
 */
class TexturesCellModifier implements ICellModifier {
	private TableViewer viewer;

	public TexturesCellModifier(TableViewer viewer) {
		this.viewer = viewer;
	}

	/**
	 * Returns whether the property can be modified
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean canModify(Object element, String property) {
		// Allow editing of all values
		if (element instanceof Item)
			element = ((Item) element).getData();

		if (TexturesComposite.NAME.equals(property)) {
			return true;
		}
		else 
		{
			return false;
		}
		
	}

	/**
	 * Returns the value for the property
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return Object
	 */
	public Object getValue(Object element, String property) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Model p = (Model) element;
	
		if (TexturesComposite.NAME.equals(property))
		{			
			return p.getName();						
		}
			return null;
		
		
	}

	/**
	 * Modifies the element
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @param value
	 *            the value
	 */
	public void modify(Object element, String property, Object value) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Model p = (Model) element;
		 if (TexturesComposite.NAME.equals(property)&&p!=null)
		{			
			p.setName((String) value);						
		}
		
		// Force the viewer to refresh
		viewer.refresh();
		
	}
}

class TexturesLabelProvider implements ITableLabelProvider {
	TableViewer viewer=null;
	/**
	 * Returns the image
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return Image
	 */
	
	public Image getColumnImage(Object element, int columnIndex) {
		Model p=null;
		
			p	 = (Model) element;
			
			return p.getImage();		
		
	}

	public TexturesLabelProvider(TableViewer viewer) {
		super();
		this.viewer=viewer;
		// TODO Auto-generated constructor stub
	}

	/**
	 * Returns the column text
	 * 
	 * @param element
	 *            the element
	 * @param columnIndex
	 *            the column index
	 * @return String
	 */
	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof Item)
			element = ((Item) element).getData();

		Model p = (Model) element;
		switch (columnIndex) {
		case 0:
			return p.getName();	
		}
		return null;
	}

	/**
	 * Adds a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void addListener(ILabelProviderListener listener) {
		// Ignore it
	}

	/**
	 * Disposes any created resources
	 */
	public void dispose() {
		// Nothing to dispose
	}

	/**
	 * Returns whether altering this property on this element will affect the label
	 * 
	 * @param element
	 *            the element
	 * @param property
	 *            the property
	 * @return boolean
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/**
	 * Removes a listener
	 * 
	 * @param listener
	 *            the listener
	 */
	public void removeListener(ILabelProviderListener listener) {
		// Ignore
	}

}
class Model {
	private String imageFile;
	private Image image;
	private String name;
	public Model(String image, String name) {
		super();
		this.imageFile = image;
		this.name = name;
	}
	public void setImage(Image iamge) {
		this.image=iamge;
	}
	public Image getImage() {
		return this.image;
	}
	public Model() {
		super();
		// TODO Auto-generated constructor stub
	}

	public Image getImage(Display display) {
		ImageData id = new ImageData(this.imageFile);
		@SuppressWarnings("deprecation")
		ImageDescriptor descriptor = ImageDescriptor.createFromImageData(id);
		LocalResourceManager rsmanager = new LocalResourceManager(JFaceResources.getResources());
		Image im = rsmanager.createImage(descriptor);
		Image scaled216 = new Image(display, im.getImageData().scaledTo(32, 32));
		return scaled216;
	}
	public void setImage(String image) {
		this.imageFile = image;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
}
