package dressing.ui;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SuperCadMessageDialog {
	/**
	 * Convenience method to open a simple confirm (OK/Cancel) dialog.
	 *
	 * @param parent  the parent shell of the dialog, or <code>null</code> if none
	 * @param title   the dialog's title, or <code>null</code> if none
	 * @param message the message
	 * @return <code>true</code> if the user presses the OK button,
	 *         <code>false</code> otherwise
	 */
    public static boolean openMessage(int kind,Shell shell, String title, String message) {
    	shell.getDisplay().asyncExec(new Runnable() {
			
			@Override
			public void run() {
				MessageDialog.open(kind, shell, title, message, SWT.NONE);
			}
		});
        return true;
    }

}
