package dressing.ui;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import dressing.config.persistence.ResourceManagers;
import dressing.ui.util.EditorWindow;
import param.Country;
import param.Fournisseur_fabricant;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Button;
import org.eclipse.core.databinding.beans.typed.PojoProperties;

public class FournisseurEditorWindow extends EditorWindow {
	private Fournisseur_fabricant frs;
	private Fournisseur_fabricant frsOrigin;
	Composite parentComposite;
	private Composite clientArea;
	private Text txtName;
	private Text txtCode;
	private Label lblNewLabel;
	private Text txtTel;
	private Button btnCheckButton;
	private Button btnChant;
	private Button btnAccessoires;
	private Text txtmail;
	private Label lblPays;
	private CountryComboSelect countryElementComboSelect;

	public FournisseurEditorWindow(Shell parentShell,Fournisseur_fabricant frs,int update) {
		super(parentShell,update);	
		this.frs=frs;
		this.frsOrigin=EcoreUtil.copy(frs);
		setTitle("Editeur Fabricant/Fournisseur");
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		parentComposite=parent;
		clientArea = new Composite(parent, SWT.BORDER);
		clientArea.setLayout(new GridLayout(2, false));
		clientArea.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		Label lblName = new Label(clientArea, SWT.NONE);
		lblName.setText("Nom");
		
		txtName = new Text(clientArea, SWT.BORDER);
		txtName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblEp = new Label(clientArea, SWT.NONE);
		lblEp.setText("Code");
		
		txtCode = new Text(clientArea, SWT.BORDER);
		txtCode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		Label lblPrice = new Label(clientArea, SWT.NONE);
		lblPrice.setText("@Email");
		txtmail = new Text(clientArea, SWT.BORDER);
		txtmail.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblNewLabel = new Label(clientArea, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText("Téléphone");
		
		txtTel = new Text(clientArea, SWT.BORDER);
		txtTel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		lblPays = new Label(clientArea, SWT.NONE);
		lblPays.setText("Pays");
		countryElementComboSelect = new CountryComboSelect(clientArea, SWT.NONE);
		countryElementComboSelect.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		ComboViewer comboViewer = countryElementComboSelect.getComboViewer();
		if(frs.getCountry()!=null) {
			comboViewer.setSelection(new StructuredSelection(frs.getCountry()), true);
		}
			
		comboViewer.addSelectionChangedListener(new  ISelectionChangedListener() {

			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				Object selection= countryElementComboSelect.getComboViewer().getStructuredSelection().getFirstElement();
				if(selection!=null && selection instanceof Country)
				{
					frs.setCountry((Country) selection);
				}
				
			}
			
		});
		
		btnCheckButton = new Button(clientArea, SWT.CHECK);
		btnCheckButton.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
		btnCheckButton.setText("Panneaux");
		
		btnChant = new Button(clientArea, SWT.CHECK);
		btnChant.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
		btnChant.setText("Chant");
		
		btnAccessoires = new Button(clientArea, SWT.CHECK);
		btnAccessoires.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 2, 1));
		btnAccessoires.setText("Accessoires");
		
		parent.requestLayout();
		
		if(frs!=null) {
			initDataBindings();
		}
		return clientArea;
	}

	@Override
	public boolean terminer() {
		if(!super.terminer()) {
			return false;
		}
		String originName =txtName.getText().trim();
//		double originEp = Double.valueOf(txtEp.getText().trim());

		this.frs.setName(originName);
//		this.frs.setEpaisseur(originEp);
		if(getUpdateMode()==EditorWindow.create) {
			ResourceManagers.getIntance().getGestion().getFabricants().getFabricants().add(frs);
		}
		ResourceManagers.getIntance().saveGestion();
		finish();
		return true;
	}
	
	@Override
	protected void cancel() {
		this.frs.setName(this.frsOrigin.getName());

	}
	@Override
	public boolean check() {
		errorExist=false;
		errorMessage="";
		String name =txtName.getText().trim();
		if(name==null || name.isEmpty()) {
			errorExist=true;
			errorMessage="Le nom est obligatoire";
		}
		return !errorExist;
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeTextTxtNameObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtName);
		IObservableValue nameChantObserveValue = PojoProperties.value("name").observe(frs);
		bindingContext.bindValue(observeTextTxtNameObserveWidget, nameChantObserveValue, null, null);
		//
		IObservableValue observeTextTxtCodeObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtCode);
		IObservableValue codeFrsObserveValue = PojoProperties.value("code").observe(frs);
		bindingContext.bindValue(observeTextTxtCodeObserveWidget, codeFrsObserveValue, null, null);
		//
		IObservableValue observeTextTxtmailObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtmail);
		IObservableValue emailFrsObserveValue = PojoProperties.value("email").observe(frs);
		bindingContext.bindValue(observeTextTxtmailObserveWidget, emailFrsObserveValue, null, null);
		//
		IObservableValue observeTextTxtTelObserveWidget = WidgetProperties.text(new int[]{SWT.Modify, SWT.FocusOut}).observe(txtTel);
		IObservableValue numTelFrsObserveValue = PojoProperties.value("numTel").observe(frs);
		bindingContext.bindValue(observeTextTxtTelObserveWidget, numTelFrsObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnCheckButtonObserveWidget = WidgetProperties.buttonSelection().observe(btnCheckButton);
		IObservableValue panneauxFrsObserveValue = PojoProperties.value("panneaux").observe(frs);
		bindingContext.bindValue(observeSelectionBtnCheckButtonObserveWidget, panneauxFrsObserveValue, null, null);
		//
		IObservableValue observeSelectionBtnChantObserveWidget =WidgetProperties.buttonSelection().observe(btnChant);
		IObservableValue chantFrsObserveValue = PojoProperties.value("chant").observe(frs);
		bindingContext.bindValue(observeSelectionBtnChantObserveWidget, chantFrsObserveValue, null, null); 
		//
		IObservableValue observeSelectionBtnAccessoiresObserveWidget = WidgetProperties.buttonSelection().observe(btnAccessoires);
		IObservableValue accessoireFrsObserveValue = PojoProperties.value("accessoire").observe(frs);
		bindingContext.bindValue(observeSelectionBtnAccessoiresObserveWidget, accessoireFrsObserveValue, null, null);
		//
		return bindingContext;
	}
}
