package dressing.ui;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

import dressing.config.persistence.ResourceManagers;
import dressing.model.elementsViewProviders.ElementProviderImp;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GestionLabelProvider;
import dressing.ui.util.ListEditorWindow;
import param.Finition;
import param.Fournisseur_fabricant;
import param.ParamFactory;

public class FournisseurComboSelect extends ElementComboSelect {

	public FournisseurComboSelect(Composite parent, int style) {
		super(parent, style);
	}

	@Override
	public IContentProvider getContentProvider() {
		return ArrayContentProvider.getInstance();
	}

	@Override
	public IBaseLabelProvider getLabelProvider() {
		return GestionLabelProvider.getInstance();

	}

	@Override
	public Object getinput() {
		ArrayList<Object> input=new ArrayList<Object>();
		input.add(new Object());
		input.addAll(ResourceManagers.getIntance().getGestion().getFabricants().getFabricants());
		return input;
	}

	@Override
	public void addElement() {
		Fournisseur_fabricant frs=ParamFactory.eINSTANCE.createFournisseur_fabricant();
		frs.setName("");
		FournisseurEditorWindow materialEditorWindow = new FournisseurEditorWindow(getShell(),frs,EditorWindow.create);
		materialEditorWindow.create();
		int ret=materialEditorWindow.open();
		if(ret==Window.OK) {
			getComboViewer().setInput(getinput());
			getComboViewer().refresh();
			getComboViewer().setSelection(new StructuredSelection(frs), true);
		}
	}

//	@Override
//	public void listElements() {
//		FournisseurListWindow frsListWindow = new FournisseurListWindow(getShell(),null);
//		frsListWindow.create();
//		int ret=frsListWindow.open();
//		getComboViewer().setInput(getinput());
//		getComboViewer().refresh();
//	}

	@Override
	public void Modify() {
		Object selection=getComboViewer().getStructuredSelection().getFirstElement();
		if(selection!=null && selection instanceof Fournisseur_fabricant) {
			Fournisseur_fabricant frs=(Fournisseur_fabricant) selection;
			FournisseurEditorWindow materialEditorWindow = new FournisseurEditorWindow(getShell(),frs,EditorWindow.update);
			materialEditorWindow.create();
			int ret=materialEditorWindow.open();
			if(ret==Window.OK) {
				getComboViewer().refresh();
			}
		}
		
	}
	@Override
	public ListEditorWindow getListEditorWindow() {
		return new FournisseurListWindow(getShell(),null);
	}
}
