package dressing.ui;
import java.text.DecimalFormat;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleTextFieldFactory {
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.0000");

    public static Text createDoubleTextField(Composite parent,int style ) {
        final Text textField = new Text(parent, SWT.NONE|style);
        final double minValue = -999999.99;   // customize as needed
        final double maxValue = 999999.99; // customize as needed
        // Set layout data to fill available horizontal space
//        textField.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Add VerifyListener to restrict input to double values
        textField.addVerifyListener(new VerifyListener() {
            @Override
            public void verifyText(VerifyEvent e) {
                // Allow empty or null input
//                if (e.text.isEmpty()) {
//                    e.doit = true;
//                   
//                    return;
//                }
               
                // Regular expression to match double values
                // Allows: positive/negative numbers with or without decimal points
                // Example valid inputs: "123.45", "-45.67", "0.123", ".45", "-.67"
                if(e.text.contentEquals(",")) {
                	e.text=".";
                }
                String regex = "(-)?(\\d+)?(\\.\\d*)?";
                String currentText = textField.getText();
                String proposedText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
                if(proposedText.isEmpty())
                {
                	e.text="0";
                	proposedText = "0";
                }
                
                if (!proposedText.matches(regex)) {
                    e.doit = false;
                    return;
                }
//                
//                // Check numeric range (only if it's parsable)
//                try {
//                    double value = Double.parseDouble(proposedText);
//                    if (value < minValue || value > maxValue) {
//                        e.doit = false;
//                    }
//                } catch (NumberFormatException ex) {
//                    e.doit = false;
//                }
            }
        });
     // Add ModifyListener to clean leading zeros
        textField.addModifyListener(new ModifyListener() {
            @Override
            public void modifyText(ModifyEvent e) {
                String original = textField.getText();
                String cleaned = cleanLeadingZeros(original);

                if (!original.equals(cleaned)) {
                    int caretPosition = textField.getCaretPosition();
                    textField.setText(cleaned);
                    textField.setSelection(Math.min(caretPosition, cleaned.length()));
                }
            }
        });
        
        // 3. FocusListener: Format to 2 decimal places and clamp to min/max
        textField.addFocusListener(new FocusAdapter() {
            @Override
            public void focusLost(FocusEvent e) {
                try {
                    double value = Double.parseDouble(textField.getText());
                    value = Math.max(minValue, Math.min(maxValue, value)); // Clamp
                    textField.setText(decimalFormat.format(value).replace(',', '.')
                    		.replaceAll("(\\.\\d*?)0+$", "$1") // remove extra zeros after decimal
                    		.replaceAll("\\.$", "")// remove trailing dot if any
                    		);
                } catch (NumberFormatException ex) {
                    textField.setText(decimalFormat.format(minValue));
                }
            }
        });
        return textField;
    }
    
    public static String cleanLeadingZeros(String input) {
        if (input == null || input.isEmpty()) return "0";

        // Preserve "0.123", convert "000123" to "123", handle negative numbers
        if (input.matches("-?0+\\.\\d*")) return input; // case like "000.45" -> "0.45"
        return input.replaceFirst("^(-?)0+(?=\\d)", "$1");
    }
    
}