package dressing.ui;

import java.util.ArrayList;
import java.util.List;
import dressing.events.EventDriver;
import dressing.model.ProjectManager;
import dressing.ui.util.MesureWidow;
import gdxapp.Commun.AbstractScreen;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomController;

public class ChangeCommandController {
 
	private static ChangeCommandController instance;
	public List<ChangeCommand> stack=new ArrayList<ChangeCommand>();
	public int index=-1; 
	public static ChangeCommandController getInstance() {
 		synchronized(MesureWidow.class) {
 			if (instance == null) {
 				instance = new ChangeCommandController();
 				
 			}
 			return instance;
 		}
	}
	
	public void addCommand(ChangeCommand command) {
		if(command!=null)
		{
			if(index!=stack.size()-1) {
				stack=stack.subList(0, index+1);
			}
			stack.add(command);
			index+=1;
			handleCmd(command);
		}else {
			System.err.println("added null command");
		}
	}
	
	private void handleCmd(ChangeCommand cmd) {
		EventDriver.getDriver().deliverEvent(cmd.getEvent());
	}

	public void undo() {
		if(index>=0) {
			stack.get(index).undo();
			index-=1;
			RoomController.refresh = true;
			if(Scene.game.getScreen() instanceof AbstractScreen)
			{
				ProjectManager.getManager().getCurrentScene().update();
			}
		}
		
	}
	
	public void redo() {
		if(index<stack.size()-1) {
			index+=1;
			stack.get(index).redo();
		
			RoomController.refresh = true;
			if(Scene.game.getScreen() instanceof AbstractScreen)
			{
				ProjectManager.getManager().getCurrentScene().update();
			}
		}
	}

	public List<ChangeCommand> getStack() {
		return stack;
	}

	public void setStack(List<ChangeCommand> stack) {
		this.stack = stack;
	}
	public void clear() {
		if(stack!=null) {
			for(int i=0;i<stack.size();i++) {
				stack.get(i).dispose();
			}
			stack.clear();
			index=-1;
		}
	}
	
}
