package dressing.ui;

import dressing.model.DesignException;
import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;

public class AddObjectCommand implements ChangeCommand {
	String name;
	String description;
	WorldObject target;
	Scene scene;
	Kitchen kitchen;
	
	public AddObjectCommand(String name, String description, WorldObject target, Scene scene, Kitchen kitchen) {
		super();
		this.name = name;
		this.description = description;
		this.target = target;
		this.scene = scene;
		this.kitchen = kitchen;
	}

	@Override
	public void redo() {
		if(target instanceof KitchenElement) {
			try {
				ProjectManager.getManager().getCurrentKitchen().addElement(((KitchenElement) target).getDesignObject());
			} catch (DesignException e) {
				e.printStackTrace();
			}
		}
		scene.addActor(target, true);
	}

	@Override
	public void verify() {
	

	}

	@Override
	public void undo() {
		if(scene!=null && target!=null) {
			scene.removeWorldObject(target);
		}
	}

	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public WorldObject getTarget() {
		return target;
	}

	public void setTarget(WorldObject target) {
		this.target = target;
	}

	public Scene getScene() {
		return scene;
	}

	public void setScene(Scene scene) {
		this.scene = scene;
	}

	public Kitchen getKitchen() {
		return kitchen;
	}

	public void setKitchen(Kitchen kitchen) {
		this.kitchen = kitchen;
	}

	@Override
	public void dispose() {
		name=null;
		description=null;
		target=null;
		scene=null;
		kitchen=null;
	}

	
}