package dressing.reporting.data.handle;

import java.util.ArrayList;
import java.util.List;

import dressing.model.stock.ModelAccessoire;
import gdxapp.object3d.DoorHandle;
import param.MechanicDesign;

public class ArticleReport {
	private String designation;
	private String reference;
	private double number;
	private double pu_ht_price;
	private double total_Net_HT;
	private double pu_ttc_price;
	private double brutHT;
	private double totalTTC;

	private double remise=15;
	private double montantRemise=15;

	private double tva=19.00;
	private MechanicDesign design;
	private double montantTva;
	private String nb; 
	private boolean isTitle;
	private double fodec=1;
	private double montantFodec;
	private DoorHandle handle;
	private List<ModelAccessoire> accessories;
	private int handlerCount;
	
	public ArticleReport() {
		super();
	}
	
	public ArticleReport(String designation, String reference, double number, double pUHTprice,
			double remise, double tva, MechanicDesign design,boolean isTitle) {
		super();
		this.designation = designation;
		this.reference = reference;
		this.number = number;
		this.pu_ht_price = pUHTprice;
		this.remise = remise;
		this.tva = tva;
		this.design=design;
		this.isTitle=isTitle;
		this.brutHT=(this.pu_ht_price * this.number);
        this.montantRemise= this.brutHT *  (this.remise / 100);
        this.total_Net_HT = this.brutHT -montantRemise;
        this.montantFodec=this.total_Net_HT *(this.fodec/100);
        this.montantTva=total_Net_HT*(this.tva/100);
        this.totalTTC=(total_Net_HT*(1+this.fodec/100))*(1+this.tva/100);
        double montontRemiseUnit=this.pu_ht_price*(this.remise / 100);
        this.pu_ttc_price=(this.pu_ht_price-montontRemiseUnit)*(1+(this.fodec/100))*(1+(this.tva/100));

	}
	
	
	public String getDesignation() {
		return designation;
	}
	public void setDesignation(String designation) {
		this.designation = designation;
	}
	public String getReference() {
		return reference;
	}
	public void setReference(String reference) {
		this.reference = reference;
	}
	public double getNumber() {
		return number;
	}
	public void setNumber(double number) {
		this.number = number;
	}

	public double getPu_ht_price() {
		return pu_ht_price;
	}
	
	public double getTotal_Net_HT() {
		return total_Net_HT;
	}
	public double getRemise() {
		return remise;
	}
	public void setRemise(double remise) {
		this.remise = remise;
	}
	public double getTva() {
		return tva;
	}
	public void setTva(double tva) {
		this.tva = tva;
	}
	
	 public double getMontantTva() {
		return montantTva;
	}
	public MechanicDesign getDesign() {
		return design;
	}
	public void setDesign(MechanicDesign design) {
		this.design = design;
	}
	
	public double getMontantRemise() {
		return montantRemise;
	}
	
	public double getBrutHT() {
		return brutHT;
	}
	
	public double getTotalTTC() {
		return totalTTC;
	}
	
	public double getPu_ttc_price() {
		return pu_ttc_price;
	}
	
	public double getMontantFodec() {
		return montantFodec;
	}
	
	public DoorHandle getHandle() {
		return handle;
	}

	public void setHandle(DoorHandle handle) {
		this.handle = handle;
	}
	

	public int getHandlerCount() {
		return handlerCount;
	}

	public void setHandlerCount(int handlerCount) {
		this.handlerCount = handlerCount;
	}

	public List<ModelAccessoire> getAccessories() {
		return accessories;
	}

	public void setAccessories(List<ModelAccessoire> accessories) {
		this.accessories = accessories;
	}
	// Method to compact a list of ArticleReports
    public static List<ArticleReport> compactArticleReports(List<ArticleReport> reports) {
        List<ArticleReport> compactedReports = new ArrayList<ArticleReport>();

        for (ArticleReport report : reports) {
            boolean found = false;

            // Check if this report matches any existing compacted report
            for (ArticleReport compactedReport : compactedReports) {
                if (report.isEqualToForCompaction(compactedReport)) {
                    // If found, update the number and recalculate total_Net_HT
                    double updatedNumber = compactedReport.getNumber() + report.getNumber();
                    compactedReport.setNumber(updatedNumber);
                    compactedReport.recalculateTTHTPrice();
                    found = true;
                    break;
                }
            }

            // If not found, add the report as it is
            if (!found) {
                compactedReports.add(report);
            }
        }

        return compactedReports;
    }

    // Method to check equality for compaction
    private boolean isEqualToForCompaction(ArticleReport other) {
        return this.designation.equals(other.getDesignation())
                && this.pu_ht_price == other.getPu_ht_price()
                && this.reference.equals(other.getReference())
                && this.remise == other.getRemise()
                && this.tva == other.getTva();
    }

    // Method to recalculate total_Net_HT
    private void recalculateTTHTPrice() {
    	this.brutHT=(this.pu_ht_price * this.number);
        this.montantRemise= this.brutHT *  (this.remise / 100);
        this.total_Net_HT = this.brutHT -montantRemise;
        this.montantFodec=this.total_Net_HT *(this.fodec/100);
        this.montantTva=(total_Net_HT+montantFodec)*(this.tva/100);
        this.totalTTC=(total_Net_HT*(1+this.fodec/100))*(1+this.tva/100);
        double montontRemiseUnit=this.pu_ht_price*(this.remise / 100);
        this.pu_ttc_price=(this.pu_ht_price-montontRemiseUnit)*(1+(this.fodec/100))*(1+(this.tva/100));
    }
	public String getNb() {
		return nb;
	}
	public void setNb(String nb) {
		this.nb = nb;
	}
	public boolean isTitle() {
		return isTitle;
	}
    
}
