package dressing.profiling;
import java.util.concurrent.ConcurrentHashMap;

public class TimeProfiler {
    private static final TimeProfiler instance = new TimeProfiler();
    private final ConcurrentHashMap<String, Long> profiles = new ConcurrentHashMap<>();
    boolean silent=false;
    private TimeProfiler() {
        // Singleton constructor
    }

    public static TimeProfiler getInstance() {
        return instance;
    }

    public void start(String label) {
        profiles.put(label, System.nanoTime());
    }

    public void stop(String label) {
        Long startTime = profiles.remove(label);
        if (startTime == null) {
        	if(!silent)
            System.err.printf("[TimeProfiler] No start time found for label '%s'%n", label);
            return;
        }

        long endTime = System.nanoTime();
        long durationNs = endTime - startTime;
        double durationUs = durationNs / 1_000.0;
        double durationMs = durationNs / 1_000_000.0;

    	if(!silent)
        System.out.printf(
            "[TimeProfiler] %s took %d ns | %.3f µs | %.3f ms%n",
            label, durationNs, durationUs, durationMs
        );
    }

    public void reset(String label) {
        profiles.remove(label);
    }

    public void clearAll() {
        profiles.clear();
    }
}