package dressing.model.ui.util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CommonStringExtractor {
    public static void main(String[] args) {
        List<String[]> nameparts = new ArrayList<>();
        
        // Populate the nameparts list with your String[] arrays
        
        // For demonstration, let's create three sample arrays
        String[] array1 = {"John", "Doe", "Smith"};
        String[] array2 = {"Jane", "Doe", "Johnson"};
//        String[] array3 = {"Alice", "Smith", "Eve"};
        
        // Add these arrays to the nameparts list
        nameparts.add(array1);
        nameparts.add(array2);
//        nameparts.add(array3);
        
        // Extract common strings
        String[] commonStrings = extractCommonStrings(nameparts);
        
        // Print the common strings
        System.out.println("Common Strings: " + Arrays.toString(commonStrings));
    }

    public static String[] extractCommonStrings(List<String[]> arrays) {
        if (arrays == null || arrays.isEmpty()) {
            return new String[0]; // Return an empty array if the input list is empty
        }

        List<String> commonStrings = new ArrayList<>(Arrays.asList(arrays.get(0)));

        for (int i = 1; i < arrays.size(); i++) {
            List<String> currentArray = Arrays.asList(arrays.get(i));
            commonStrings.retainAll(currentArray);
        }

        return commonStrings.toArray(new String[0]);
    }
}

