package dressing.model.ui.project3d;

import javax.inject.Inject;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.model.Project3D;
import dressing.model.ProjectParent;



public class Project3DWizard extends Wizard{

	//L injection ne peut etre en marche que si on creer l objet avec contextfactory et non pas avec l objet new
	@Inject
	IEclipseContext  eclipsecontext;

	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;

	ProjectParent root;
	Project3D project3d = new Project3D();
	public Project3DWizard () {
		setWindowTitle("Nouveau projet");		
	}

	@Override
	public void addPages() {
		
		addPage(new Projet3DWizardPage("ProjectPage",project3d));		
	}

	@Override
	public boolean performFinish() {
		
			if(root!=null)
			{
				root.addProject(project3d,false);
				//Sauvegarder l emplacemt du reportoire
				
				Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
				Preferences projectpref = preferences.node("project3d");
				projectpref.put("directory", project3d.getDirectory());
				try {
					preferences.flush();
				} catch (BackingStoreException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				return true;
			}
			return false;
	}	
	
	public void setRoot(ProjectParent root) {
		this.root = root;
	}

@Override
public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
}
}
