package dressing.model.types;

public enum PoigneePosition {

	TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_RIGHT, TOP_MIDDLE, BOTTOM_MIDDLE, LEFT_MIDDLE, RIGHT_MIDDLE, CENTER;

	@Override
	public String toString() {
		switch (this) {
			case TOP_LEFT:
				return "Haut gauche";
			case TOP_RIGHT:
				return "Haut droite";
			case BOTTOM_LEFT:
				return "Bas gauche";
			case BOTTOM_RIGHT:
				return "Bas droite";
			case TOP_MIDDLE:
				return "haut milieu";
			case LEFT_MIDDLE:
				return "Gauche milieu";
			case BOTTOM_MIDDLE:
				return "Bas milieu";
			case RIGHT_MIDDLE:
				return "Droite milieu";
			default:
				return "Centre";
		}
	}

	public boolean isLeft() {
		return this == TOP_LEFT || this == BOTTOM_LEFT || this == LEFT_MIDDLE;
	}

	public boolean isRight() {
		return this == TOP_RIGHT || this == BOTTOM_RIGHT || this == RIGHT_MIDDLE;
	}
	
	public boolean isTop() {
		return this == TOP_RIGHT || this == TOP_LEFT || this == TOP_MIDDLE;
	}
	public boolean isBottom() {
		return this == BOTTOM_RIGHT || this == BOTTOM_LEFT|| this == BOTTOM_MIDDLE;
	}
	public boolean isMiddle() {
		return !(isTop()||isBottom());
	}
}
