package dressing.model.persistence.dpos;

import dressing.ui.engine3d.SceneTexture;
import gdxapp.fabs3d.WoodCovering;
import gdxapp.object3d.WorldObject;
import gdxapp.shaders.PbrMaterial;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="Habillage")
public class WoodCoveringDPO extends Object3D implements DPO<WoodCovering> {
	
	private float bandWidth;
	private float extrusionWidth;
	private float extrusionDepth;
	private PbrMaterial material;
	
	public WoodCoveringDPO() {};
	
	public WoodCoveringDPO(WoodCovering habillage) {
		super(habillage);
		bandWidth = habillage.getBandWidth();
		extrusionWidth = habillage.getExtrusionWidth();
		extrusionDepth = habillage.getExtrusionDepth();
		material = habillage.getMaterial();
	}
	
	
	private void set(WoodCovering habillage) {
		super.set(habillage);
		setBandWidth(habillage.getBandWidth());
		setExtrusionDepth(habillage.getExtrusionDepth());
		setExtrusionWidth(habillage.getExtrusionWidth());
		setMaterial(habillage.getMaterial());
	}

	@Override
	public WorldObject getWorldActor() {
		WoodCovering habillage = new WoodCovering(bandWidth, extrusionWidth, extrusionDepth);
		habillage.setRealWorldDimension(this.dimension);
		habillage.setRealWorldPosition(this.position);
		habillage.setMaterial(material);
		return  habillage;
	}
	
	
	@Override
	public WoodCovering get() {
		WoodCovering covering = new WoodCovering();
		super.get(covering);
		covering.setBandWidth(bandWidth);
		covering.setExtrusionDepth(extrusionDepth);
		covering.setExtrusionWidth(extrusionWidth);
		covering.setMaterial(material);
		return covering;
	}

	@Override
	public WoodCoveringDPO from(WoodCovering entity) {
		WoodCoveringDPO dpo = new WoodCoveringDPO();
		dpo.set(entity);
		return dpo;
	}
	
	

	//getters and setters
	public float getBandWidth() {
		return bandWidth;
	}

	public void setBandWidth(float bandWidth) {
		this.bandWidth = bandWidth;
	}

	public float getExtrusionWidth() {
		return extrusionWidth;
	}

	public void setExtrusionWidth(float extrusionWidth) {
		this.extrusionWidth = extrusionWidth;
	}

	public float getExtrusionDepth() {
		return extrusionDepth;
	}

	public void setExtrusionDepth(float extrusionDepth) {
		this.extrusionDepth = extrusionDepth;
	}

	public PbrMaterial getMaterial() {
		return material;
	}

	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}
}
