package dressing.model.persistence.dpos;

import java.util.ArrayList;

import com.badlogic.gdx.math.Matrix4;

import gdxapp.shaders.PbrMaterial;
import geometry.CompoundShape;
import geometry.Shape;

public class CompoundShapeDPO implements DPO<CompoundShape>{
	
	private ArrayList<Shape> nodes = new ArrayList<Shape>();
	private boolean closed = false;
	private PbrMaterial material;
	private Matrix4 worldTransform;
	
	
	@Override
	public DPO<CompoundShape> from(CompoundShape entity) {
		CompoundShapeDPO dpo = new CompoundShapeDPO();
		dpo.setNodes(entity.getNodes());
		dpo.setMaterial(entity.getMaterial());
		dpo.setClosed(entity.isClosed());
		dpo.setWorldTransform(entity.getWorldTransform());
		return dpo;
	}

	@Override
	public CompoundShape get() {
		CompoundShape compoundShape = new CompoundShape();
		compoundShape.setNodes(this.nodes.toArray(new Shape[0]));
		compoundShape.setMaterial(material);
		compoundShape.setClosed(this.isClosed());
		compoundShape.setWorldTransform(this.worldTransform);
		return compoundShape;
	}

	public ArrayList<Shape> getNodes() {
		return nodes;
	}

	public void setNodes(ArrayList<Shape> nodes) {
		this.nodes = nodes;
	}
	

	public PbrMaterial getMaterial() {
		return material;
	}

	public void setMaterial(PbrMaterial material) {
		this.material = material;
	}

	public boolean isClosed() {
		return closed;
	}

	public void setClosed(boolean closed) {
		this.closed = closed;
	}

	public Matrix4 getWorldTransform() {
		return worldTransform;
	}

	public void setWorldTransform(Matrix4 worldTransform) {
		this.worldTransform = worldTransform;
	}
	
}
