package dressing.model.persistence;

import java.util.Map;

public class MapEntry {

	Object key;
	Object value;
	
	
	public MapEntry() {
		super();
	}
	public MapEntry(Object key, Object value) {
		super();
		this.key = key;
		this.value = value;
	}
	
	public Object getKey() {
		return key;
	}
	public void setKey(Object key) {
		this.key = key;
	}
	public Object getValue() {
		return value;
	}
	public void setValue(Object value) {
		this.value = value;
	}
	
	public static <K, V> MapEntry[] of(Map<K, V> map) {
		MapEntry[] entries = new MapEntry[map.values().size()];
		int c = 0;
		for(Map.Entry<K, V> entry : map.entrySet()) {
			entries[c++] = new MapEntry(entry.getKey(), entry.getValue());
		}
		return entries;
	}
	
	
}
