package dressing.model.debitage;

import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptContext;
import javax.script.ScriptException;

import org.frs.debitage.engine.core.evalutor.Equation;
import org.frs.debitage.engine.core.evalutor.GeomtericEngine;

import dressing.model.AssemblyContainerModel;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.FaceModel;
import param.AccessoireInstance;
import param.AssemblyContainer;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.QuincaillerieInstance;

public class AssemblyContainerDebitageFormila extends GenericDebitageFormula {

	public AssemblyContainerDebitageFormila() {
		super();
		// TODO Auto-generated constructor stub
	}

	public static void filldebitagesequations(DesignObject3D parent, AssemblyContainerModel container, AssemblyContainer node,
			List<MechanicPublicParam> publicparams, ArrayList<Equation> equations) throws DesignException {
		if (container == null)
			throw new DesignException("Formule de debitage : child null");
		GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE).clear();
		GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE).clear();
		if (parent != null) {
			GeomtericEngine.getLogicalEngine().put("PARENT", parent);
			GeomtericEngine.getLogicalEngine().put("CHILD", container);
			GeomtericEngine.getEngine().put("PARENT", parent);
			GeomtericEngine.getEngine().put("CHILD", container);
			
		}

		// check exist logic
		try {

			fillequationsfrompublicparam(equations, publicparams);
			fillequationsfromparent(parent, equations);
			fillequationsfromemfmodel(equations, node);

		} finally {
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.GLOBAL_SCOPE).clear();
			GeomtericEngine.getLogicalEngine().getContext().getBindings(ScriptContext.ENGINE_SCOPE).clear();
		}

	}
	private static void fillequationsfromemfmodel(ArrayList<Equation> equations, AssemblyContainer emf) throws DesignException {

		
			List<param.Equation> articleEquationequations = new ArrayList<param.Equation>();
			articleEquationequations.add(( emf).getPosition().getX());
			articleEquationequations.add(( emf).getPosition().getY());
			articleEquationequations.add(( emf).getPosition().getZ());

			fillequationsfromgenericequations(equations, articleEquationequations);

		

	}
}
