package dressing.model;

import dressing.model.types.IntersectionType;

public class Plan3D {

	Point3D[] extremes=new Point3D[8];

	Intervale xinter;
	Intervale yinter;
	Intervale zinter;
	
	public Point3D[] getExtremes() {
		return extremes;
	}

	public Intervale getXinter() {
		return xinter;
	}

	public void setXinter(Intervale xinter) {
		this.xinter = xinter;
	}

	public Intervale getYinter() {
		return yinter;
	}

	public void setYinter(Intervale yinter) {
		this.yinter = yinter;
	}

	public Intervale getZinter() {
		return zinter;
	}

	public void setZinter(Intervale zinter) {
		this.zinter = zinter;
	}

	public void setExtremes(Point3D[] extremes) {
		this.extremes = extremes;
	}

	public Plan3D(Point3D[] extremes) {
		super();
		initializeIntervales(extremes);
	}
	
	public Plan3D() {
		super();
		// TODO Auto-generated constructor stub
	}

	public Plan3D(Intervale xinter, Intervale yinter, Intervale zinter) {
		super();
		this.xinter = xinter;
		this.yinter = yinter;
		this.zinter = zinter;
	}

	public Plan3D(DesignObject3D obj) {
		this.extremes=obj.redifinePoints();
		initializeIntervales(extremes);
	}
	public void initializeIntervales(Point3D[] extremes) {
		this.extremes = extremes;
		double xmax=this.extremes[0].getX();
		double xmin=this.extremes[0].getX();
		double ymax=this.extremes[0].getY();
		double ymin=this.extremes[0].getY();
		double zmax=this.extremes[0].getZ();
		double zmin=this.extremes[0].getZ();

		if(this.extremes!=null) {
			for(Point3D point:this.extremes ) {
				//determine xmax& xmin
				if(point.getX()>xmax) {
					xmax=point.getX();
				}
				if(point.getX()<xmin) {
					xmin=point.getX();
				}
				//determine ymax& ymin
				if(point.getY()>ymax) {
					ymax=point.getY();
				}
				if(point.getY()<ymin) {
					ymin=point.getY();
				}
				//determine zmax& zmin
				if(point.getZ()>zmax) {
					zmax=point.getZ();
				}
				if(point.getZ()<zmin) {
					zmin=point.getZ();
				}
								
			}
			this.xinter=new Intervale(xmin, true, xmax, true);
			this.yinter=new Intervale(ymin, true, ymax, true);
			this.zinter=new Intervale(zmin, true, zmax, true);

		}
	}
	
	public Plan3D getIntersection(Plan3D plan) {
		
		Intervale xintersection=getXinter().getintersection(plan.getXinter());
		Intervale yintersection=getYinter().getintersection(plan.getYinter());
		Intervale zintersection=getZinter().getintersection(plan.getZinter());
		return new Plan3D(xintersection,yintersection,zintersection);
	}
	public IntersectionType isIntersect(Plan3D planche2){
		
		Plan3D intersection=this.getIntersection(planche2);
		if(intersection.getXinter()==null || intersection.getYinter()==null|| intersection.getZinter()==null) {
			return IntersectionType.NOT_RELATED;
		}else {
			if(intersection.getXinter().isPoint() || intersection.getYinter().isPoint()|| intersection.getZinter().isPoint())
			return IntersectionType.TANGENT;
		}
		return IntersectionType.INTERSECTION;
		 
	}
	public static IntersectionType getPlan3DType(Plan3D intersection){
		
		if(intersection.getXinter()==null || intersection.getYinter()==null|| intersection.getZinter()==null) {
			return IntersectionType.NOT_RELATED;
		}else {
			if(intersection.getXinter().isPoint() || intersection.getYinter().isPoint()|| intersection.getZinter().isPoint())
			return IntersectionType.TANGENT;
		}
		return IntersectionType.INTERSECTION;
		 
	}
	public double getSize() {
		double size=0;
		if(xinter!=null ) {
			size=xinter.getlong();	
		}
		if(yinter!=null) {
			if(size==0) {
				size=yinter.getlong();
			}else {
				size*=yinter.getlong();
			}
		}
		if(zinter!=null) {
			if(size==0) {
				size=zinter.getlong();
			}else {
				size*=zinter.getlong();
			}
		}
		return size;
	}
	 public static void main(String[] args) {
		 Intervale inter1=new Intervale(3, true, 10, true);
		 Intervale inter2=new Intervale(5, true, 7, true);		 
		 System.out.println("intervale intersection(expected:5-7) :"+inter1.getintersection(inter2).toString());
		 
		 
		 Intervale inter3=new Intervale(6, true, 10, true);
		 Intervale inter4=new Intervale(5, true, 7, true);		 
		 System.out.println("intervale intersection(expected:6-7) :"+inter3.getintersection(inter4).toString());

		 Intervale inter5=new Intervale(7, true, 10, true);
		 Intervale inter6=new Intervale(5, true, 7, true);
		 System.out.println("intervale intersection(expected:7-7) :"+inter5.getintersection(inter6).toString());

		 Intervale inter7=new Intervale(7.1, true, 10, true);
		 Intervale inter8=new Intervale(5, true, 7, true);
		 System.out.println("intervale intersection(expected:null) :"+inter7.getintersection(inter8));

		 

	 }

	 
	 public boolean contains(Plan3D cyl) {
		 boolean iscontainsX=getXinter().contains(cyl.getXinter());
		 boolean iscontainsY=getYinter().contains(cyl.getYinter());
		 boolean iscontainsZ=getZinter().contains(cyl.getZinter());

		 return iscontainsX && iscontainsY && iscontainsZ;
	 }
	 
	 @Override
	protected void finalize() throws Throwable {
		this.xinter=null;
		this.yinter=null;
		this.zinter=null;
		for(Point3D p:this.extremes) {
			p=null;
		}
		this.extremes=null;
		super.finalize();
	}
}
