package dressing.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;

import org.frs.debitage.engine.core.evalutor.GeometricEngineException;

import dressing.config.persistence.ResourceManagers;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.object3d.WorldObjectFactory;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneManager;
import jakarta.xml.bind.annotation.XmlRootElement;
import param.AccessoireInstance;
import param.Material;
import param.MechanicDesign;
import param.QuincaillerieInstance;
import param.impl.MaterialImpl;

@XmlRootElement(name = "Kitchen")
public class Kitchen extends ObservableEntity implements TreeElement {

	private UUID uuid;
	private String name;
	private float width;
	private float height;
	private transient MaterialImpl primaryMaterial = null;
	private transient MaterialImpl backMaterial = null;
	private transient MaterialImpl faceMaterial = null;
	private UUID idPrimaryMaterial = null;
	private UUID idbackMaterial = null;
	private UUID idFaceMaterial = null;
	private transient SuperCadProject project = null;
	private transient List<MechanicDesign> elementDefinitions;
	private transient List<DesignObject3D> elements;
	private transient Scene scene = new Scene();
	private String screenshotPath;
	private transient ArrayList<ModelAccessoire> accessoires = new ArrayList<ModelAccessoire>();
	private transient ArrayList<ModelQuincaillerie> quincailleries = new ArrayList<ModelQuincaillerie>();
	private ArrayList<AccessoireInstance> accessoiresDefinition = new ArrayList<AccessoireInstance>();

	

	public Kitchen() {}

	public Kitchen(SuperCadProject project) {
		super();
		this.elementDefinitions = new ArrayList<MechanicDesign>();
		this.elements = new ArrayList<DesignObject3D>();
		this.project = project;
	}

	public void init() {
		this.elementDefinitions = new ArrayList<MechanicDesign>();
		this.elements = new ArrayList<DesignObject3D>();
		this.accessoires = new ArrayList<ModelAccessoire>();
		this.quincailleries = new ArrayList<ModelQuincaillerie>();
		if (accessoiresDefinition == null) {
			accessoiresDefinition = new ArrayList<AccessoireInstance>();
		}
		this.faceMaterial=(MaterialImpl) ResourceManagers.getIntance().getMaterial(idFaceMaterial);
		this.primaryMaterial=(MaterialImpl) ResourceManagers.getIntance().getMaterial(idPrimaryMaterial);
		this.backMaterial=(MaterialImpl) ResourceManagers.getIntance().getMaterial(idbackMaterial);
		
		this.propertyChangeSupport = new PropertyChangeSupport(this);
	}

	public void generateElementsUsinage() {
		try {
			for (DesignObject3D designObject : elements) {
				((Space3DFree) designObject).refresh();
			}
		} catch (Exception e) {
			MessageBox dialog = new MessageBox(null, SWT.ICON_ERROR | SWT.OK | SWT.CANCEL);
			dialog.setText("Error");
			dialog.setMessage("un erreur est servenue lors de mise à jour du model à cause de :" + e.getMessage());

			// open dialog and await user selection
			int returnCode = dialog.open();
			e.printStackTrace();
		}

	}

	public DesignObject3D getElement(UUID id) {
		DesignObject3D element = null;
		for (DesignObject3D elementX : this.elements) {
			if (elementX.getID().equals(id))
				element = elementX;
		}
		return element;
	}

	public void removeElement(Space3D space) {
		if (this.elements.contains(space)) {
			if (this.elementDefinitions.contains(space.getMechanicDesignDefinition())) {
				this.elementDefinitions.remove(space.getMechanicDesignDefinition());
			}
			this.elements.remove(space);
			propagatePropertyChangeEvent("elements", elements, null);
//			space.dispose();
			System.gc();
		}
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		firePropertyChangeEvent("name", this.name, name);
		this.name = name;
	}

	public float getWidth() {
		return width;
	}

	public void setWidth(float width) {
		firePropertyChangeEvent("width", this.width, width);
		this.width = width;
	}

	public float getHeight() {
		return height;
	}

	public void setHeight(float height) {
		firePropertyChangeEvent("height", this.height, height);
		this.height = height;
	}

	public MaterialImpl getPrimaryMaterial() {
		if (this.primaryMaterial != null)
			return primaryMaterial;
		return null;
	}

	public void setPrimaryMaterial(MaterialImpl primaryMaterial) {
		firePropertyChangeEvent("primaryMaterial", this.primaryMaterial, primaryMaterial);
		this.primaryMaterial = primaryMaterial;
		if(this.primaryMaterial!=null)
		{
			this.idPrimaryMaterial=this.primaryMaterial.getModelId();
		}
	}

	public MaterialImpl getFaceMaterial() {
		return faceMaterial;
	}

	public void setFaceMaterial(MaterialImpl faceMaterial) {
		firePropertyChangeEvent("faceMaterial", this.faceMaterial, faceMaterial);
		this.faceMaterial = faceMaterial;
		if(this.faceMaterial!=null)
		{
			this.idFaceMaterial=this.faceMaterial.getModelId();
		}
	}

	public MaterialImpl getBackMaterial() {
		if (this.backMaterial != null)
			return backMaterial;
		return null;
	}

	public void setBackMaterial(MaterialImpl backMaterial) {
		firePropertyChangeEvent("backMaterial", this.backMaterial, backMaterial);
		this.backMaterial = backMaterial;
		if(this.backMaterial!=null)
		{
			this.idbackMaterial=this.backMaterial.getModelId();
		}
	}

	public UUID getIdPrimaryMaterial() {
		return idPrimaryMaterial;
	}

	public void setIdPrimaryMaterial(UUID idPrimaryMaterial) {
		this.idPrimaryMaterial = idPrimaryMaterial;
	}

	public UUID getIdbackMaterial() {
		return idbackMaterial;
	}

	public void setIdbackMaterial(UUID idbackMaterial) {
		this.idbackMaterial = idbackMaterial;
	}

	public UUID getIdFaceMaterial() {
		return idFaceMaterial;
	}

	public void setIdFaceMaterial(UUID idFaceMaterial) {
		this.idFaceMaterial = idFaceMaterial;
	}

	public String getScreenshotPath() {
		return screenshotPath;
	}

	public void setScreenshotPath(String screenshotPath) {
		this.screenshotPath = screenshotPath;
	}

	public SuperCadProject getProject() {
		return project;
	}

	public void setProject(SuperCadProject project) {
		firePropertyChangeEvent("project", this.project, project);
		this.project = project;
		if (!this.project.getKitchens().contains(this))
			this.project.getKitchens().add(this);
	}

	public List<MechanicDesign> getElementDefinitions() {
		return elementDefinitions;
	}

	public void setElementDefinitions(List<MechanicDesign> elementDefinitions) {
		firePropertyChangeEvent("elementDefinitions", this.elements, elements);
		this.elementDefinitions = elementDefinitions;
	}

	public void buildElements() {
		this.elements.clear();
		if (this.elementDefinitions != null) {
			for (MechanicDesign md : this.elementDefinitions) {
				try {
					DesignObject3D designobject = MechanicDesignCreator.getInstance().constructObject(
							ModelProvider.getModelroot(), null, null, md, MechanicDesignCreator.open, false);
					addElement(designobject);
				} catch (DesignException | GeometricEngineException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		buildAccessoires();
	}

	public void buildAccessoires() {
		if (accessoiresDefinition != null && accessoiresDefinition.size() > 0) {
			this.getAccessoires().clear();
			this.getQuincailleries().clear();
			for (AccessoireInstance accessoire : accessoiresDefinition) {
				if (accessoire != null && accessoire.getAccessoire() != null) {
					ModelAccessoire model = new ModelAccessoire(accessoire);
					model.setId(accessoire.getAccessoire().getModelId());
					model.setName(accessoire.getAccessoire().getName());
					model.setNumber(accessoire.getNombreFix());
					addAccessoire(model);
					if (accessoire.getAccessoire().getQuincailleries() != null
							&& accessoire.getAccessoire().getQuincailleries().getQuincailleries() != null
							&& accessoire.getAccessoire().getQuincailleries().getQuincailleries().size() > 0) {
						EList<QuincaillerieInstance> quincailleries = accessoire.getAccessoire().getQuincailleries()
								.getQuincailleries();
						for (QuincaillerieInstance quincaillerie : quincailleries) {
							if (quincaillerie != null && quincaillerie.getQuincaillerie() != null) {
								ModelQuincaillerie modelquincaillerie = new ModelQuincaillerie(quincaillerie, model);
								modelquincaillerie.setId(quincaillerie.getQuincaillerie().getModelId());
								modelquincaillerie.setName(quincaillerie.getName());

								modelquincaillerie.setNumber(quincaillerie.getNombreFix() * model.getNumber());
								addQuincaillerie(modelquincaillerie);

							}
						}
					}
				}
			}

		}
	}

	public ArrayList<ModelAccessoire> getAccessoires() {
		if (accessoires == null) {
			accessoires = new ArrayList<ModelAccessoire>();
		}
		return accessoires;
	}

	public void setAccessoires(ArrayList<ModelAccessoire> accessoires) {
		this.accessoires = accessoires;
	}

	public ArrayList<ModelQuincaillerie> getQuincailleries() {
		if (quincailleries == null) {
			quincailleries = new ArrayList<ModelQuincaillerie>();
		}
		return quincailleries;
	}

	public void setQuincailleries(ArrayList<ModelQuincaillerie> quincailleries) {
		this.quincailleries = quincailleries;
	}

	public void addAccessoire(ModelAccessoire accessoire) {
		if (accessoires != null && accessoire != null) {
//			ModelAccessoire accessoireold=null;
//			for(ModelAccessoire access:accessoires) {
//				if(access.getId().equals(accessoire.getId())) {
//					accessoireold=access;
//					break;
//				}
//			}
//			if(accessoireold!=null) {
//				accessoireold.setNumber(accessoireold.getNumber()+accessoire.getNumber());
//			}else {
			accessoires.add(accessoire);
//			}
		}
	}

	public void addQuincaillerie(ModelQuincaillerie quincaillerie) {
		if (quincailleries != null && quincaillerie != null) {
//			ModelQuincaillerie quincaillerieold=null;
//			for(ModelQuincaillerie access:quincailleries) {
//				if(access.getId().equals(quincaillerie.getId())) {
//					quincaillerieold=access;
//					break;
//				}
//			}
//			if(quincaillerieold!=null) {
//				quincaillerieold.setNumber(quincaillerieold.getNumber()+quincaillerie.getNumber());
//			}else {
			quincailleries.add(quincaillerie);
//			}
		}
	}

	
	@Override
	public Object getDirectParent() {
		// TODO Auto-generated method stub
		return this.project;
	}

	@Override
	public boolean hasChildren() {
		// TODO Auto-generated method stub
		if (this.elements == null)
			return false;
		return this.elements.size() > 0;
	}

	
	@Override
	public Object[] getChildren() {
		// TODO Auto-generated method stub
		return this.elements.toArray();
	}

	@Override
	public String getNodeName() {
		// TODO Auto-generated method stub
		if (this.name != null)
			return this.name;
		return "unnamed kitchen";
	}

	@Override
	public String getLabelIconPath() {
		return "icon-cuisine.png";
	}

	public UUID getUuid() {
		return uuid;
	}

	public void setUuid(UUID uuid) {
		this.uuid = uuid;
	}

	public List<DesignObject3D> getElements() {
		return elements;
	}

	public List<DesignObject3D> getElementsWithoutFausseFacades() {
		List<DesignObject3D> objects = new ArrayList<DesignObject3D>();
		for (DesignObject3D object : elements) {
			if (!object.getDesignCaissonType().contentEquals("FAUSSE_FACADE")) {
				objects.add(object);
			}
		}
		return objects;
	}

	public List<DesignObject3D> getElementsFausseFacades() {
		List<DesignObject3D> objects = new ArrayList<DesignObject3D>();
		for (DesignObject3D object : elements) {
			if (object.getDesignCaissonType().contentEquals("FAUSSE_FACADE")) {
				objects.add(object);
			}
		}
		return objects;
	}

	public void addElement(DesignObject3D child) throws DesignException {
		if (child == null) {
			throw new DesignException("Impossible d'ajouter un child null");
		} else {
			child.addPropertyChangeListener(new PropertyChangeListener() {

				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if (!evt.getPropertyName().equalsIgnoreCase("selected")) {
						propagatePropertyChangeEvent("project.modify", null, child);
					}

				}
			});
			elements.add(child);
			child.setKitchen(this);
			propagatePropertyChangeEvent("project.child.added", null, child);
		}
	}

	public void setElements(List<DesignObject3D> elements) {
		this.elements = elements;
	}

	@Override
	public void propagatePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
		firePropertyChangeEvent(propertyName, oldValue, newValue);
		Object parent = this.getDirectParent();
		if (parent != null) {
			if (parent instanceof ObservableEntity) {
				((ObservableEntity) parent).firePropertyChangeEvent(propertyName, oldValue, newValue);
				((ObservableEntity) parent).propagatePropertyChangeEvent(propertyName, oldValue, newValue);
			}
		}
	}

	public boolean containsElement(Space3DFree o) {
		if (this.elements != null)
			return this.elements.contains(o);
		return false;
	}

	public void loadScene(String path) {
		SceneManager.instance.loadScene(path);

	}

	public Scene getScene() {
		return scene;
	}
	
	public Scene getOrCreateNewScene() {
		if(scene == null)
			scene = new Scene();
		return scene;
	}

	public String getKitchenpath() {
		String projectPath = ProjectManager.getManager().getCurrentProjectDirectory();
		String kitchenPath = projectPath + "/" + getName();
		File file = new File(kitchenPath);
		String path = "";
		try {
			path = "file://" + file.toURL().getPath();
		} catch (MalformedURLException e) {
			path = "Not Foud";
			e.printStackTrace();
		}
		return path;
	}

	public List<Piece2D> getListPieces() {
		List<Piece2D> pieces = new ArrayList<Piece2D>();
		for (DesignObject3D design : getElements()) {

			pieces.addAll(design.getListPieces());
		}

		return pieces;
	}

	public List<Piece2D> getListPiecesWithoutFausseFacades() {
		List<Piece2D> pieces = new ArrayList<Piece2D>();
		List<DesignObject3D> elts = getElementsWithoutFausseFacades();
		for (DesignObject3D design : elts) {

			pieces.addAll(design.getListPieces());
		}

		return pieces;
	}

	
	public List<Piece2D> getListCotes() {
		List<Piece2D> pieces = new ArrayList<Piece2D>();
		for (DesignObject3D design : getElements()) {
			pieces.addAll(design.getListCotes());
		}
		return pieces;
	}

	public Kitchen copy() {
		Kitchen kitchen = new Kitchen(getProject());
		kitchen.setUuid(UUID.randomUUID());
		kitchen.setName(getName() + "1");
		kitchen.setWidth(getWidth());
		kitchen.setHeight(getHeight());
		kitchen.setBackMaterial(getBackMaterial());
		kitchen.setPrimaryMaterial(getPrimaryMaterial());
		kitchen.setFaceMaterial(getFaceMaterial());
//		for(MechanicDesign design:elementDefinitions) {
//			MechanicDesign copy=EcoreUtil.copy(design);
//			kitchen.getElementDefinitions().add(copy);
//			try {
//				DesignObject3D designobject = MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(), null, null, copy, MechanicDesignCreator.create);
//				kitchen.addElement(designobject);
//			} catch (DesignException | GeometricEngineException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
//
//		}
		for (WorldObject object : scene.getSceneObjects()) {
			KitchenElement element = null;
			if (object instanceof KitchenElement) {
				element = (KitchenElement) object;
			}
			if (object.getType().equals(ObjectType.MODELED)) {
				WorldObject copy = object.clone();
				kitchen.scene.addActor(copy, false);
			} else {
				MechanicDesign mDesign = element.getMechanicDesign();
				MechanicDesign copy = EcoreUtil.copy(mDesign);
				try {
					DesignObject3D designobject = MechanicDesignCreator.getInstance().constructObject(
							ModelProvider.getModelroot(), null, null, copy, MechanicDesignCreator.create, false);
					kitchen.addElement(designobject);
					kitchen.elementDefinitions.add(copy);

					WorldObject wobject = WorldObjectFactory.getFactory().createObjectFromDefinition(designobject);
					wobject.setRealWorldPosition(object.getRealWorldPosition().cpy());
					wobject.setRotation(object.getRotation());
					wobject.setRequireRefrech(true);
					kitchen.scene.addActor(wobject, false);
				} catch (DesignException | GeometricEngineException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			}
		}

		kitchen.scene.setQuotationMode(scene.getQuotationMode());
		kitchen.scene.setPreferences(scene.getPreferences().clone());
		kitchen.scene.requireRefresh = true;

		return kitchen;
	}

	public void setScene(Scene other) {
		scene = other;

	}

	

}
