package dressing.handlers.pieces2d;

import javax.inject.Inject;


import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.swt.widgets.Shell;

import dressing.cam.model.PlanUsinage;
import dressing.model.Piece2D;
import dressing.cam.model.PlanUsinage;
import dressing.ui.parts.Edit2DPiece;

public class ViewFaceHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(ParameterizedCommand command,EPartService partService,Shell shell){
		MPart part  = partService.getActivePart();
		if(part!=null)
		{
			Object o = part.getObject();
			if(o instanceof Edit2DPiece)
			{
				Edit2DPiece perspectiveview2d= (Edit2DPiece)o;
				if(command.getParameterMap().get("dressing.commandparameter.perspective.choosed")==null)
				{
					
				}
				else
				{
					String persp = (String) command.getParameterMap().get("dressing.commandparameter.perspective.choosed");
					switch (persp) {
					case "Face":
						perspectiveview2d.setViewPerspective(PlanUsinage.FRONT);
						break;
					case "Back":
						perspectiveview2d.setViewPerspective(PlanUsinage.BACK);
						break;
					case "Haut":
						perspectiveview2d.setViewPerspective(PlanUsinage.TOP);
						break;
					case "Bas":
						perspectiveview2d.setViewPerspective(PlanUsinage.DOWN);
						break;
					case "Droite":
						perspectiveview2d.setViewPerspective(PlanUsinage.RIGHT);
						break;	
					case "Gauche":
						perspectiveview2d.setViewPerspective(PlanUsinage.LEFT);
						break;		
					default:
						perspectiveview2d.setViewPerspective(PlanUsinage.FRONT);
						break;
					}

				}
				
			}
		}
	
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection();
		
		//Voire l element de l arbre selectionne
		if(o instanceof Piece2D)
		{
			return true;
		}	
		return false;
	}
}
