package dressing.handlers.gdx;

import javax.inject.Inject;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

import com.badlogic.gdx.Gdx;

import dressing.controller.tools.ToolController;
import dressing.model.ProjectManager;
import gdxapp.shapes.ShapeType;
import supercad.eclipse.service.EclipseServiceProvider;

public class ToolControlHandler {
	

	@Inject
	private static ECommandService commandService;
	@Inject
	private static EHandlerService handlerService;
	
	private static ToolControlHandler instance;

	public ToolControlHandler() {
		
	}
	
	@Execute
	public boolean execute(ParameterizedCommand command) {
		if(command.getParameterMap().get("dressing.commandparameter.tool.mode")!=null)
		{
			
			String state = "";
			command.getCommand().getState(state);
			
			Runnable action;
		
			String persp = (String) command.getParameterMap().get("dressing.commandparameter.tool.mode");
			switch (persp) {
			case "zoom":
				action = () ->  ToolController.getInstance().setZOOM();
				break;
			case "selectionZone":
				action = () ->  ToolController.getInstance().setSELECT_ZONE();
				break;
			case "selectionMode":
				action = () -> ToolController.getInstance().setSELECT_Objects();
				break;
			case "surfaceSelection":
				action = () -> ToolController.getInstance().setSELECT_SURFACE();
	        	 break;
			case "mesureDistance":
				action = () -> ToolController.getInstance().setMEASURE_DISTANCE();
				break;
			case "drawWall":
				action = () -> ToolController.getInstance().setDRAW_WALL();
				break;
			case "drawRoomPolygon":
				action = () ->  ToolController.getInstance().setDRAW_ROOM_POLYGONE(ShapeType.POLYGON);
				break;
			case "allowDragWall":
				action = () -> ToolController.getInstance().setALLOW_WALL_MOVE();
				break;
			case "drawMarblePolygon":
				action = () -> ToolController.getInstance().setDRAW_POLYGONE_MARBLE();
	        	 break;
			case "dragObjects":
				action = () -> ToolController.getInstance().setDRAG_OBJECTS();
				break;
			case "drawExtrusion":
				action = () -> ToolController.getInstance().setDrawExtrusion();
				break;
			
			case "write text":
				action = () -> ToolController.getInstance().setWriteText();
				break;
			case "unzoom":
				action = () ->  ToolController.getInstance().unzoom();
				break;
			case "arrow":
				action = () ->  ToolController.getInstance().setARROW_TAKER();
				break;
			case "polyline":
				action = () -> ToolController.getInstance().setDRAW_ROOM_POLYGONE(ShapeType.POLYLINE);
				break;
			case "FreeMove":
				action = () -> ToolController.getInstance().setFREE_MOVE();
				break;
			case "FreezeMove":
				action = () -> ToolController.getInstance().setFREEZE_MOVE();
				break;
			default:
				action = () -> ToolController.getInstance().setSELECT_Objects();
				break ;
			}
			
			Gdx.app.postRunnable(action);
			return true;
		}
		return false;
	}
	
	@SuppressWarnings("restriction")
	public void triggerSelectObject() {
		try {
			MPart part = EclipseServiceProvider.getServiceProvider().getPartService().getActivePart();
			MWindow window = EclipseServiceProvider.getServiceProvider().getModelService() .getTopLevelWindowFor(part);
			MHandledToolItem selectItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.cursor.mode", MHandledToolItem.class).get(0);
			MHandledToolItem surfaceItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.surfaceSelection", MHandledToolItem.class).get(0);
			
			MHandledToolItem zoomItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.zoom", MHandledToolItem.class).get(0);
			MHandledToolItem measureItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.measure.distance", MHandledToolItem.class).get(0);
			surfaceItem.setSelected(false);
			selectItem.setSelected(true);
			zoomItem.setSelected(false);
			measureItem.setSelected(false);
			Event event = new Event();
			Widget widget = (Widget) selectItem.getWidget();
	        event.widget = widget;
	        event.type = SWT.Selection;
	        //Notify listeners (simulate a press)
	        for (Listener listener : widget.getListeners(SWT.Selection)) {
	            listener.handleEvent(event);
	        }
		}catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	public synchronized void threadSafeTriggerSelectObject() {
		Display.getDefault().asyncExec(() -> {
			triggerSelectObject();
		});
	}
	
	@SuppressWarnings("restriction")
	public void triggerDeactivateSelectObject() {
		try {
			MPart part = EclipseServiceProvider.getServiceProvider().getPartService().getActivePart();
			MWindow window = EclipseServiceProvider.getServiceProvider().getModelService() .getTopLevelWindowFor(part);
			MHandledToolItem selectItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.cursor.mode", MHandledToolItem.class).get(0);
			selectItem.setSelected(false);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@SuppressWarnings("restriction")
	public void triggerDeactivateZoom() {
		try {
			MPart part = EclipseServiceProvider.getServiceProvider().getPartService().getActivePart();
			MWindow window = EclipseServiceProvider.getServiceProvider().getModelService() .getTopLevelWindowFor(part);
			
			MHandledToolItem zoomItem = EclipseServiceProvider.getServiceProvider().getModelService().findElements(window, 
					"dressing.handledtoolitem.zoom", MHandledToolItem.class).get(0);
			zoomItem.setSelected(false);

		}catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}

	public static ToolControlHandler getInstance() {
		if(instance == null)
			instance = new ToolControlHandler();
		return instance;
	}

}
