package dressing.handlers.gdx;

import java.io.File;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import com.badlogic.gdx.Gdx;
import dressing.model.ProjectManager;
import gdxapp.Commun.ScreenshotFactory;


public class TakeScreenShotHandler {
	
	String path;

	@Execute
	public void execute(Shell shell) {
		FileDialog fileDialog = new FileDialog(shell, SWT.SAVE);
		String[] extensions = {".png"};
		fileDialog.setFilterExtensions(extensions);
		Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
		Preferences projectpref = preferences.node("SuperCadProject");
		String defaultpath=projectpref.get("SaveAsdirectory", System.getProperty("user.home") + File.separator + "Desktop");
		String dirpath = projectpref.get("directoryWrite", defaultpath);
		fileDialog.setFilterPath(dirpath);
		path = fileDialog.open();
		if(path != null && !path.isEmpty()) {
			Gdx.app.postRunnable(new Runnable() {
				@Override
				public void run() {
					File file = new File(path);
					file.getParentFile().mkdirs();
					int width = Gdx.graphics.getWidth();
					int height = width * 21/29;
					ScreenshotFactory.saveCapture(width, height, 1024, path);
				}
			});
			File f = new File(path);
			dirpath = f.getParent();
			projectpref.put("directoryWrite", dirpath);
			try {
				projectpref.flush();
			} catch (BackingStoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		 

		
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}

}
