package dressing.handlers.gdx;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.Gdx;

import dressing.model.ProjectManager;
import dressing.ui.engine3d.sceneconfig.SceneConfigWindow;
import dressing.ui.engine3d.sceneconfig.SceneConfigWizard;
import dressing.ui.engine3d.sceneconfig.SceneConfigurationEditorWindow;
import dressing.ui.util.EditorWindow;
import gdxapp.scenes.Scene;
import gdxapp.screens.room.RoomScreen;

public class SetScenePreferences {

	@Execute
	public void execute(Shell shell) {
		SceneConfigurationEditorWindow window = new SceneConfigurationEditorWindow(shell, EditorWindow.executeAction);
		window.setPreferences(ProjectManager.getManager().getCurrentScene().getPreferences());
		window.open();
	}
	
	@CanExecute
	public boolean check() {
		if(ProjectManager.getManager().getCurrentKitchen()==null) {
			return false;
		}
		return true;
	}
}
