package dressing.handlers;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.io.ProjectRecoveryTool;
import dressing.ui.parts.GdxPart;

public class ProjectRecoveryInvoker {
	
	@Execute
	public void execute(Shell shell) {
		DirectoryDialog dd = new DirectoryDialog(shell, SWT.OPEN);
		String path = dd.open();
		if(path != null) {
			ProjectRecoveryTool.getRecoveryTool().setShell(shell);
			ProjectRecoveryTool.getRecoveryTool().recoverProject(path);
		}
	}
	
	@CanExecute
	public boolean canExecute() {
		return true;
	}

}
