package dressing.handlers;

import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import gdxapp.DressingRoomApp;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.room3d.Room3DScreen;


public class PlumbingEditorInvoker {

	
	@Execute
	public void execute(Shell shell) {
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.PLUMBING_EDITOR.name(), null));
	}
	
	@CanExecute
	public boolean check() {
		return (Scene.game != null && Scene.game.getScreen() instanceof Room3DScreen);
	}
}
